/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.attachment.instrumentopen;

import com.cstav.genshinstrument.attachment.ModAttachments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public class InstrumentOpen
implements INBTSerializable<CompoundTag> {
    public static final String OPEN_TAG = "InstrumentOpen";
    public static final String IS_ITEM_TAG = "IsItem";
    public static final String BLOCK_POS_TAG = "BlockPos";
    public static final String HAND_TAG = "InOffhand";
    private boolean isOpen = false;
    private boolean isItem = false;
    private BlockPos blockPos;
    private InteractionHand hand;

    public static boolean isOpen(Player player) {
        InstrumentOpen oIsOpen = (InstrumentOpen)player.getData(ModAttachments.INSTRUMENT_OPEN);
        return oIsOpen.isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean isItem() {
        return this.isItem;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public void setOpen(InteractionHand hand) {
        this.isOpen = true;
        this.hand = hand;
        this.isItem = true;
    }

    public void setOpen(BlockPos blockPos) {
        this.isOpen = true;
        this.blockPos = blockPos;
        this.isItem = false;
    }

    public void setClosed() {
        this.isOpen = false;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public @UnknownNullability CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean(OPEN_TAG, this.isOpen);
        nbt.putBoolean(IS_ITEM_TAG, this.isItem);
        if (this.blockPos != null) {
            nbt.put(BLOCK_POS_TAG, NbtUtils.writeBlockPos((BlockPos)this.blockPos));
        }
        if (this.hand != null) {
            nbt.putBoolean(HAND_TAG, this.hand == InteractionHand.OFF_HAND);
        }
        return nbt;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.isOpen = nbt.getBoolean(OPEN_TAG);
        this.isItem = nbt.getBoolean(IS_ITEM_TAG);
        this.blockPos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)BLOCK_POS_TAG).orElse(null);
        if (nbt.contains(HAND_TAG, 1)) {
            this.hand = nbt.getBoolean(HAND_TAG) ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        }
    }
}

