/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.block.partial;

import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.block.partial.InstrumentBlockEntity;
import com.cstav.genshinstrument.client.ModArmPose;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInstrumentBlock
extends BaseEntityBlock {
    private Object clientBlockArmPose;

    public AbstractInstrumentBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        if (!FMLEnvironment.dist.isDedicatedServer()) {
            this.initClientBlockUseAnim(pose -> {
                this.clientBlockArmPose = pose;
            });
        }
    }

    protected abstract void onInstrumentOpen(ServerPlayer var1);

    public abstract InstrumentBlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    protected void initClientBlockUseAnim(Consumer<HumanoidModel.ArmPose> consumer) {
        consumer.accept((HumanoidModel.ArmPose)ModArmPose.PLAYING_BLOCK_INSTRUMENT_EP.getValue());
    }

    @OnlyIn(value=Dist.CLIENT)
    public HumanoidModel.ArmPose getClientBlockArmPose() {
        return (HumanoidModel.ArmPose)this.clientBlockArmPose;
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.CONSUME;
        }
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof InstrumentBlockEntity)) {
            return InteractionResult.FAIL;
        }
        if (InstrumentPacketUtil.sendOpenPacket((ServerPlayer)pPlayer, this::onInstrumentOpen, pPos)) {
            ((InstrumentBlockEntity)be).users.add(pPlayer.getUUID());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity be = pLevel.getBlockEntity(pPos);
        if (!(be instanceof InstrumentBlockEntity)) {
            super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
            return;
        }
        InstrumentBlockEntity ibe = (InstrumentBlockEntity)be;
        for (Player player : pLevel.players()) {
            ibe.users.forEach(user -> {
                InstrumentOpenProvider.setClosed(pLevel.getPlayerByUUID(user));
                GIPacketHandler.sendToClient(new NotifyInstrumentOpenPacket((UUID)user), (ServerPlayer)player);
            });
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }
}

