/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.config;

import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.client.config.enumType.NoteGridLabel;
import com.cstav.genshinstrument.client.config.enumType.ZitherSoundType;
import com.cstav.genshinstrument.client.gui.screen.instrument.djemdjemdrum.DjemDjemDrumNoteLabel;
import com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum.DominantGloriousDrumType;
import com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum.GloriousDrumNoteLabel;
import com.cstav.genshinstrument.client.gui.screen.instrument.ukelele.Ukulele3rdOctaveType;
import com.cstav.genshinstrument.sound.NoteSound;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public class ModClientConfigs {
    public static final ModConfigSpec CONFIGS;
    public static final ModConfigSpec.IntValue PITCH;
    public static final ModConfigSpec.IntValue MIDI_DEVICE_INDEX;
    public static final ModConfigSpec.IntValue OCTAVE_SHIFT;
    public static final ModConfigSpec.IntValue MIDI_CHANNEL;
    public static final ModConfigSpec.DoubleValue VOLUME;
    public static final ModConfigSpec.DoubleValue MIDI_IN_SENSITIVITY;
    public static final ModConfigSpec.EnumValue<NoteGridLabel> GRID_LABEL_TYPE;
    public static final ModConfigSpec.EnumValue<InstrumentChannelType> CHANNEL_TYPE;
    public static final ModConfigSpec.BooleanValue STOP_MUSIC_ON_PLAY;
    public static final ModConfigSpec.BooleanValue SHARED_INSTRUMENT;
    public static final ModConfigSpec.BooleanValue RENDER_BACKGROUND;
    public static final ModConfigSpec.BooleanValue ACCEPTED_GENSHIN_CONSENT;
    public static final ModConfigSpec.BooleanValue ACCURATE_NOTES;
    public static final ModConfigSpec.BooleanValue MIDI_ENABLED;
    public static final ModConfigSpec.BooleanValue EXTEND_OCTAVES;
    public static final ModConfigSpec.BooleanValue FIXED_TOUCH;
    public static final ModConfigSpec.BooleanValue ACCEPT_ALL_CHANNELS;
    public static final ModConfigSpec.BooleanValue NORMALIZE_VINTAGE_LYRE;
    public static final ModConfigSpec.EnumValue<ZitherSoundType> ZITHER_SOUND_TYPE;
    public static final ModConfigSpec.EnumValue<GloriousDrumNoteLabel> GLORIOUS_DRUM_LABEL_TYPE;
    public static final ModConfigSpec.EnumValue<DjemDjemDrumNoteLabel> DJEM_DJEM_DRUM_LABEL_TYPE;
    public static final ModConfigSpec.EnumValue<DominantGloriousDrumType> DOMINANT_DRUM_TYPE;
    public static final ModConfigSpec.EnumValue<Ukulele3rdOctaveType> UKULELE_3RD_OCTAVE_TYPE;

    static {
        ModConfigSpec.Builder configBuilder = new ModConfigSpec.Builder();
        PITCH = configBuilder.defineInRange("instrument_pitch", 0, NoteSound.MIN_PITCH, NoteSound.MAX_PITCH);
        VOLUME = configBuilder.defineInRange("instrument_volume", 1.0, 0.0, 1.0);
        GRID_LABEL_TYPE = configBuilder.defineEnum("label_type", (Enum)NoteGridLabel.KEYBOARD_LAYOUT);
        CHANNEL_TYPE = configBuilder.defineEnum("channel_type", (Enum)InstrumentChannelType.MIXED);
        STOP_MUSIC_ON_PLAY = configBuilder.comment("Stops all background music when you or someone else within 10.0 blocks of range plays an instrument").define("stop_music_on_play", true);
        SHARED_INSTRUMENT = configBuilder.comment("Defines whether you will see others playing on your instrument's screen").define("display_other_players", true);
        RENDER_BACKGROUND = configBuilder.define("render_background", true);
        ACCURATE_NOTES = configBuilder.define("accurate_notes", true);
        NORMALIZE_VINTAGE_LYRE = configBuilder.define("normalize_vintage_lyre", true);
        ACCEPTED_GENSHIN_CONSENT = configBuilder.define("accepted_genshin_consent", false);
        ZITHER_SOUND_TYPE = configBuilder.defineEnum("zither_sound_type", (Enum)ZitherSoundType.NEW);
        GLORIOUS_DRUM_LABEL_TYPE = configBuilder.defineEnum("glorious_drum_label_type", (Enum)GloriousDrumNoteLabel.KEYBOARD_LAYOUT);
        DJEM_DJEM_DRUM_LABEL_TYPE = configBuilder.defineEnum("djem_djem_drum_label_type", (Enum)DjemDjemDrumNoteLabel.KEYBOARD_LAYOUT);
        MIDI_ENABLED = configBuilder.define("midi_enabled", false);
        MIDI_DEVICE_INDEX = configBuilder.defineInRange("midi_device_index", -1, -1, Integer.MAX_VALUE);
        MIDI_IN_SENSITIVITY = configBuilder.defineInRange("midi_in_sensitivity", 0.8, 0.0, 1.0);
        EXTEND_OCTAVES = configBuilder.comment("When a note that is higher/lower than the usual octave range is played, will automatically adjust the pitch to match your playings. Can only extend up to 1 octave per side: high and low C.").define("extend_octaves", true);
        FIXED_TOUCH = configBuilder.comment("Defines whether the velocity of a note press will not affect the instrument's volume").define("fixed_touch", false);
        ACCEPT_ALL_CHANNELS = configBuilder.define("accept_all_channels", true);
        OCTAVE_SHIFT = configBuilder.defineInRange("midi_octave_shift", 0, -5, 5);
        MIDI_CHANNEL = configBuilder.defineInRange("midi_channel", 0, 0, 15);
        DOMINANT_DRUM_TYPE = configBuilder.comment("Defines the MIDI split behaviour of the Arataki's Great and Glorious Drum").defineEnum("dominant_drum_type", (Enum)DominantGloriousDrumType.BOTH);
        UKULELE_3RD_OCTAVE_TYPE = configBuilder.defineEnum("ukulele_3rd_octave_type", (Enum)Ukulele3rdOctaveType.CHORDS);
        CONFIGS = configBuilder.build();
    }
}

