/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.WarningScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GenshinConsentScreen
extends WarningScreen {
    private static final Component TITLE = Component.translatable((String)"genshinstrument.genshin_disclaimer.title").withStyle(ChatFormatting.BOLD);
    private static final MutableComponent CONTENT = Component.translatable((String)"genshinstrument.genshin_disclaimer.content", (Object[])GenshinConsentScreen.boldenAll(2));
    private static final Component NARRATION = TITLE.copy().append("\n").append((Component)CONTENT);
    private final Screen previousScreen;

    public GenshinConsentScreen(Screen previousScreen) {
        super(TITLE, (Component)CONTENT, null, NARRATION);
        this.previousScreen = previousScreen;
    }

    protected Layout addFooterButtons() {
        Button acknowledgeButton = Button.builder((Component)CommonComponents.GUI_ACKNOWLEDGE, button -> {
            ModClientConfigs.ACCEPTED_GENSHIN_CONSENT.set((Object)true);
            ModClientConfigs.ACCEPTED_GENSHIN_CONSENT.save();
            this.minecraft.setScreen(this.previousScreen);
        }).build();
        acknowledgeButton.setPosition((this.width - acknowledgeButton.getWidth()) / 2, this.height - acknowledgeButton.getHeight() - 10);
        LinearLayout linearlayout = LinearLayout.vertical().spacing(8);
        linearlayout.addChild((LayoutElement)acknowledgeButton);
        return linearlayout;
    }

    private static Component bolden(int index) {
        return Component.translatable((String)("genshinstrument.genshin_disclaimer.bolden" + index)).withStyle(ChatFormatting.BOLD);
    }

    private static Object[] boldenAll(int amount) {
        Object[] result = new Object[amount];
        for (int i = 0; i < amount; ++i) {
            result[i] = GenshinConsentScreen.bolden(i + 1);
        }
        return result;
    }

    public void onClose() {
        super.onClose();
        this.previousScreen.onClose();
    }
}

