/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InstrumentScreenRegistry {
    private static final HashMap<ResourceLocation, Supplier<? extends InstrumentScreen>> INSTRUMENT_SCREENS = new HashMap();

    public static void register(ResourceLocation instrumentID, Supplier<? extends InstrumentScreen> screenInitiator) {
        INSTRUMENT_SCREENS.put(instrumentID, screenInitiator);
    }

    public static void register(Map<ResourceLocation, Supplier<? extends InstrumentScreen>> instrumentMap) {
        instrumentMap.forEach(InstrumentScreenRegistry::register);
    }

    public static void setScreenByID(ResourceLocation instrumentID) {
        try {
            Minecraft.getInstance().setScreen((Screen)InstrumentScreenRegistry.instantiateById(instrumentID));
        }
        catch (Exception e) {
            GInstrumentMod.LOGGER.error("Exception thrown trying to open an instrument screen " + String.valueOf(instrumentID), (Throwable)e);
        }
    }

    public static InstrumentScreen instantiateById(ResourceLocation instrumentID) {
        return INSTRUMENT_SCREENS.get(instrumentID).get();
    }
}

