/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum.DominantGloriousDrumType;
import com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum.GloriousDrumButtonType;
import com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum.GloriousDrumNoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.gloriousdrum.GloriousDrumOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class AratakisGreatAndGloriousDrumScreen
extends InstrumentScreen {
    public static final ResourceLocation INSTRUMENT_ID = GInstrumentMod.loc("glorious_drum");
    public static final String[] NOTE_LAYOUT = new String[]{"D", "G"};
    private final HashMap<InputConstants.Key, NoteButton> notes = new HashMap();
    public static final InstrumentThemeLoader THEME_LOADER = new InstrumentThemeLoader(INSTRUMENT_ID);

    @Override
    public ResourceLocation getInstrumentId() {
        return INSTRUMENT_ID;
    }

    @Override
    public Map<InputConstants.Key, NoteButton> noteMap() {
        return this.notes;
    }

    @Override
    protected InstrumentOptionsScreen initInstrumentOptionsScreen() {
        return new GloriousDrumOptionsScreen(this);
    }

    @Override
    protected void init() {
        this.initOptionsButton(this.height / 2 + 25);
        LinearLayout layout1 = this.createRow(GloriousDrumButtonType.DON, 2.0f);
        LinearLayout layout2 = this.createRow(GloriousDrumButtonType.KA, 1.3f);
        layout1.arrangeElements();
        layout2.arrangeElements();
        layout1.setPosition((this.width - layout1.getWidth()) / 2, (int)((float)this.height * 0.8f));
        layout2.setPosition((this.width - layout2.getWidth()) / 2, layout1.getY() - layout1.getHeight() / 2);
        layout1.arrangeElements();
        layout2.arrangeElements();
        layout1.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        layout2.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.notesIterable().forEach(NoteButton::init);
        super.init();
    }

    private LinearLayout createRow(GloriousDrumButtonType type, float widthPercent) {
        LinearLayout layout = new LinearLayout(0, 0, LinearLayout.Orientation.HORIZONTAL);
        layout.spacing((int)((float)this.width / widthPercent) - 80);
        this.createButton(type, layout, false);
        this.createButton(type, layout, true);
        return layout;
    }

    private GloriousDrumNoteButton createButton(GloriousDrumButtonType btnType, LinearLayout container, boolean isRight) {
        GloriousDrumNoteButton btn = new GloriousDrumNoteButton(btnType, isRight, this);
        container.addChild((LayoutElement)btn);
        this.notes.put(btn.getKey(), btn);
        return btn;
    }

    @Override
    public String[] noteLayout() {
        return NOTE_LAYOUT;
    }

    @Override
    public InstrumentThemeLoader getThemeLoader() {
        return THEME_LOADER;
    }

    @Override
    public InstrumentMidiReceiver initMidiReceiver() {
        return new InstrumentMidiReceiver(this){
            private static boolean donRight = false;
            private static boolean kaRight = false;

            @Override
            @Nullable
            protected NoteButton handleMidiPress(int note, int key) {
                boolean isKa = AratakisGreatAndGloriousDrumScreen.ddt() == DominantGloriousDrumType.KA || AratakisGreatAndGloriousDrumScreen.ddt() == DominantGloriousDrumType.BOTH && note >= 12;
                AratakisGreatAndGloriousDrumScreen.this.setPitch(note - (isKa ? 19 : 2));
                for (NoteButton noteButton : AratakisGreatAndGloriousDrumScreen.this.notesIterable()) {
                    GloriousDrumNoteButton dnb = (GloriousDrumNoteButton)noteButton;
                    if (dnb.btnType != (isKa ? GloriousDrumButtonType.KA : GloriousDrumButtonType.DON)) continue;
                    if (isKa) {
                        if (dnb.isRight != kaRight) continue;
                        kaRight = !kaRight;
                        return dnb;
                    }
                    if (dnb.isRight != donRight) continue;
                    donRight = !donRight;
                    return dnb;
                }
                return null;
            }

            @Override
            protected NoteButton getLowestNote() {
                return AratakisGreatAndGloriousDrumScreen.this.notes.values().stream().map(btn -> (GloriousDrumNoteButton)((Object)btn)).filter(btn -> btn.btnType == this.getDrumTypeOf(GloriousDrumButtonType.DON)).findFirst().get();
            }

            @Override
            protected NoteButton getHighestNote() {
                return AratakisGreatAndGloriousDrumScreen.this.notes.values().stream().map(btn -> (GloriousDrumNoteButton)((Object)btn)).filter(btn -> btn.btnType == this.getDrumTypeOf(GloriousDrumButtonType.KA)).findFirst().get();
            }

            private GloriousDrumButtonType getDrumTypeOf(GloriousDrumButtonType btnType) {
                DominantGloriousDrumType ddt = AratakisGreatAndGloriousDrumScreen.ddt();
                return ddt == DominantGloriousDrumType.BOTH ? btnType : (ddt == DominantGloriousDrumType.DON ? GloriousDrumButtonType.DON : GloriousDrumButtonType.KA);
            }

            @Override
            protected int minMidiNote() {
                return AratakisGreatAndGloriousDrumScreen.ddt() == DominantGloriousDrumType.BOTH || AratakisGreatAndGloriousDrumScreen.ddt() == DominantGloriousDrumType.DON ? -10 : 7;
            }

            @Override
            protected int maxMidiNote() {
                return AratakisGreatAndGloriousDrumScreen.ddt() == DominantGloriousDrumType.BOTH || AratakisGreatAndGloriousDrumScreen.ddt() == DominantGloriousDrumType.KA ? 32 : 15;
            }
        };
    }

    private static DominantGloriousDrumType ddt() {
        return (DominantGloriousDrumType)((Object)ModClientConfigs.DOMINANT_DRUM_TYPE.get());
    }
}

