/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.IHoldableNoteButton;
import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface IHeldInstrumentScreen {
    public HeldNoteSound[] getHeldNoteSounds();

    public void setHeldNoteSounds(HeldNoteSound[] var1);

    default public InstrumentScreen asScreen() {
        return (InstrumentScreen)((Object)this);
    }

    default public void foreignPlayHeld(InstrumentPlayedEvent<?> event) {
        if (!(event instanceof HeldNoteSoundPlayedEvent)) {
            return;
        }
        HeldNoteSoundPlayedEvent e = (HeldNoteSoundPlayedEvent)event;
        if (e.phase == HeldSoundPhase.RELEASE) {
            return;
        }
        try {
            NoteButton note = this.asScreen().getNoteButton(event.soundMeta().noteIdentifier(), ((HeldNoteSound)e.sound()).getSound(HeldNoteSound.Phase.ATTACK), event.soundMeta().pitch());
            IHoldableNoteButton heldNote = (IHoldableNoteButton)((Object)note);
            heldNote.playAttackAnimation(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    default public void releaseForeign(HeldNoteSoundPlayedEvent event) {
        try {
            NoteButton note = this.asScreen().getNoteButton(event.soundMeta().noteIdentifier(), ((HeldNoteSound)event.sound()).getSound(HeldNoteSound.Phase.ATTACK), event.soundMeta().pitch());
            IHoldableNoteButton heldNote = (IHoldableNoteButton)((Object)note);
            if (!heldNote.isHeld()) {
                return;
            }
            heldNote.playReleaseAnimation(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    default public void closeHeldScreen() {
        LocalPlayer player = Minecraft.getInstance().player;
        HeldNoteSounds.getUnique(HeldNoteSounds.release(InitiatorID.fromEntity((Entity)player))).forEach(sound -> HeldNoteSounds.notifyRelease(sound, ((NoteButton)((Object)((Object)this.getNoteButton(sound.heldSoundContainer, sound.notePitch)))).getIdentifier()));
    }

    default public IHoldableNoteButton getNoteButton(HeldNoteSound noteSound, int pitch) {
        for (NoteButton note : this.asScreen().notesIterable()) {
            IHoldableNoteButton heldNote = (IHoldableNoteButton)((Object)note);
            HeldNoteSound sound = heldNote.getHeldNoteSound();
            if (!noteSound.equals(sound) || this.asScreen().identifyByPitch() && note.getPitch() != pitch) continue;
            return (IHoldableNoteButton)((Object)note);
        }
        throw new NoSuchElementException("Could not find a note in " + String.valueOf(this.asScreen().getInstrumentId()) + " based on the given identifier");
    }
}

