/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial;

import com.cstav.genshinstrument.GInstrumentMod;
import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.GenshinConsentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.NoteLabelSupplier;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.InstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.IconToggleButton;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.cstav.genshinstrument.client.midi.InstrumentMidiReceiver;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.NoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.buttonidentifier.NoteButtonIdentifier;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.CloseInstrumentPacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class InstrumentScreen
extends Screen {
    private static final int VISIBILITY_BUTTON_MARGIN = 6;
    private static final String VISIBILITY_SPRITE_LOC = "textures/gui/sprites/icon/visibility/";
    private int pitch;
    public int volume = (int)((Double)ModClientConfigs.VOLUME.get() * 100.0);
    private NoteLabelSupplier noteLabelSupplier;
    public final InstrumentMidiReceiver midiReceiver;
    public final InstrumentOptionsScreen optionsScreen = this.initInstrumentOptionsScreen();
    protected IconToggleButton visibilityButton;
    private boolean pitchChanged;
    private boolean isOptionsScreenActive;
    private boolean closed = false;

    public int getNoteSize() {
        return switch ((Integer)Minecraft.getInstance().options.guiScale().get()) {
            case 1 -> 36;
            case 2 -> 46;
            case 3 -> 48;
            case 4 -> 40;
            case 5 -> 35;
            case 6 -> 30;
            default -> 35;
        };
    }

    public int getPitch() {
        return this.pitch;
    }

    public void setPitch(int pitch) {
        this.pitch = NoteSound.clampPitch(pitch);
        this.notesIterable().forEach(note -> note.setPitch(this.pitch));
    }

    protected void initPitch(Consumer<Integer> pitchConsumer) {
        pitchConsumer.accept((Integer)ModClientConfigs.PITCH.get());
    }

    public void resetPitch() {
        this.initPitch(this::setPitch);
    }

    public float volume() {
        return (float)this.volume / 100.0f;
    }

    public void setVolume(float volume) {
        this.volume = (int)(volume * 100.0f);
    }

    public void setNoteSounds(NoteSound[] sounds) {
        Iterator<NoteButton> noteIterator = this.notesIterable().iterator();
        int i = 0;
        while (noteIterator.hasNext() && i < sounds.length) {
            noteIterator.next().setSound(sounds[i++]);
        }
        if (noteIterator.hasNext() || i < sounds.length) {
            LogUtils.getLogger().warn("Not all sounds were set for instrument " + String.valueOf(this.getInstrumentId()) + "!");
        }
    }

    public void setLabelSupplier(NoteLabelSupplier supplier) {
        this.noteLabelSupplier = supplier;
        this.notesIterable().forEach(note -> note.setLabelSupplier(supplier));
    }

    public NoteLabelSupplier getNoteLabelSupplier() {
        return this.noteLabelSupplier;
    }

    public abstract InstrumentThemeLoader getThemeLoader();

    public abstract ResourceLocation getInstrumentId();

    protected abstract InstrumentOptionsScreen initInstrumentOptionsScreen();

    public String[] noteLayout() {
        return null;
    }

    public boolean isGenshinInstrument() {
        return true;
    }

    public InstrumentMidiReceiver initMidiReceiver() {
        return null;
    }

    public boolean isMidiInstrument() {
        return this.midiReceiver != null;
    }

    public void handleAbruptClosing() {
        if (!InstrumentOpenProvider.isOpen((Player)this.minecraft.player)) {
            this.onClose(false);
        }
    }

    public NoteButton getNoteButton(Optional<NoteButtonIdentifier> noteIdentifier, NoteSound noteSound, int pitch) throws NoSuchElementException {
        if (noteIdentifier.isEmpty()) {
            return this.getNoteButton(noteSound, pitch);
        }
        return this.getNoteButton(noteIdentifier.get());
    }

    public NoteButton getNoteButton(NoteButtonIdentifier noteIdentifier) {
        for (NoteButton note : this.notesIterable()) {
            if (!noteIdentifier.matches(note)) continue;
            return note;
        }
        throw new NoSuchElementException("Could not find a note in " + String.valueOf(this.getInstrumentId()) + " based on the given identifier");
    }

    public NoteButton getNoteButton(NoteSound noteSound, int pitch) {
        for (NoteButton note : this.notesIterable()) {
            NoteSound sound = note.getSound();
            if (!noteSound.equals(sound) || this.identifyByPitch() && note.getPitch() != pitch) continue;
            return note;
        }
        throw new NoSuchElementException("Could not find a note in " + String.valueOf(this.getInstrumentId()) + " based on the given identifier");
    }

    protected boolean identifyByPitch() {
        return false;
    }

    public abstract Map<InputConstants.Key, NoteButton> noteMap();

    public Iterable<NoteButton> notesIterable() {
        return this.noteMap().values();
    }

    public static String getGlobalRootPath() {
        return "textures/gui/genshinstrument/";
    }

    public ResourceLocation getResourceFromGlob(String path) {
        return this.getSourcePath().withPath(InstrumentScreen.getGlobalRootPath() + "instrument/" + path);
    }

    public static ResourceLocation getInternalResourceFromGlob(String path) {
        return GInstrumentMod.loc(InstrumentScreen.getGlobalRootPath() + path);
    }

    public static ResourceLocation getInstrumentRootPath(ResourceLocation instrumentId) {
        return instrumentId.withPath(InstrumentScreen.getGlobalRootPath() + "instrument/" + instrumentId.getPath());
    }

    protected String getPath() {
        return InstrumentScreen.getGlobalRootPath() + "instrument/" + this.getSourcePath().getPath() + "/";
    }

    public ResourceLocation getSourcePath() {
        return this.getThemeLoader().subjectInstrumentId;
    }

    public String getModId() {
        return this.getInstrumentId().getNamespace();
    }

    public ResourceLocation getResourceFromRoot(String path, boolean considerGlobal) {
        return considerGlobal && InstrumentThemeLoader.isGlobalThemed() ? InstrumentThemeLoader.GLOBAL_LOC.withSuffix("/" + path) : this.getSourcePath().withPath(this.getPath() + path);
    }

    public ResourceLocation getResourceFromRoot(String path) {
        return this.getResourceFromRoot(path, true);
    }

    public InstrumentScreen() {
        super(CommonComponents.EMPTY);
        this.midiReceiver = this.initMidiReceiver();
    }

    protected void init() {
        this.resetPitch();
        this.optionsScreen.init(this.minecraft, this.width, this.height);
        boolean wasEnabled = false;
        if (this.visibilityButton != null) {
            wasEnabled = this.visibilityButton.enabled();
        }
        this.visibilityButton = this.initVisibilityButton();
        this.addRenderableWidget((GuiEventListener)this.visibilityButton);
        this.visibilityButton.setEnabled(wasEnabled);
        if (this.isGenshinInstrument() && !((Boolean)ModClientConfigs.ACCEPTED_GENSHIN_CONSENT.get()).booleanValue()) {
            this.minecraft.setScreen((Screen)new GenshinConsentScreen(this));
        }
    }

    protected Button initOptionsButton(int vertOffset) {
        Button button = Button.builder((Component)Component.translatable((String)"button.genshinstrument.instrumentOptions").append("..."), btn -> this.onOptionsOpen()).width(150).build();
        button.setPosition((this.width - button.getWidth()) / 2, vertOffset - button.getHeight() / 2);
        this.addRenderableWidget((GuiEventListener)button);
        return button;
    }

    protected IconToggleButton initVisibilityButton() {
        return new IconToggleButton(6, 6, GInstrumentMod.loc("textures/gui/sprites/icon/visibility/enabled.png"), GInstrumentMod.loc("textures/gui/sprites/icon/visibility/disabled.png"), btn -> this.onInstrumentRenderStateChanged(this.instrumentRenders()));
    }

    public void foreignPlay(InstrumentPlayedEvent<?> event) {
        if (!(event instanceof NoteSoundPlayedEvent)) {
            return;
        }
        NoteSoundPlayedEvent e = (NoteSoundPlayedEvent)event;
        try {
            this.getNoteButton(event.soundMeta().noteIdentifier(), (NoteSound)e.sound(), event.soundMeta().pitch()).playNoteAnimation(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean instrumentRenders() {
        return !this.visibilityButton.enabled();
    }

    protected void onInstrumentRenderStateChanged(boolean isVisible) {
        if (!isVisible) {
            this.notesIterable().forEach(note -> note.getRenderer().resetAnimations());
        }
        this.renderables.forEach(renderable -> {
            if (renderable instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)renderable;
                widget.active = isVisible;
            }
        });
        this.visibilityButton.active = true;
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.instrumentRenders()) {
            this.visibilityButton.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
            return;
        }
        this.renderInstrument(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    public void renderInstrument(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.checkPitchTransposeUp(pKeyCode, pScanCode)) {
            return true;
        }
        NoteButton note = this.getNoteByKey(pKeyCode);
        if (note != null) {
            note.play();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        GuiEventListener guiEventListener;
        if (this.checkTransposeDown(pKeyCode, pScanCode)) {
            return true;
        }
        if (this.isFocused() && (guiEventListener = this.getFocused()) instanceof NoteButton) {
            NoteButton btn = (NoteButton)guiEventListener;
            btn.release();
        }
        if (!this.isKeyConsumed(pKeyCode, pScanCode)) {
            return false;
        }
        this.unlockFocused();
        NoteButton note = this.getNoteByKey(pKeyCode);
        if (note != null) {
            note.release();
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    protected boolean checkPitchTransposeUp(int pKeyCode, int pScanCode) {
        if (this.pitchChanged) {
            return false;
        }
        if (this.checkTransposeUpKey(pKeyCode, pScanCode)) {
            this.transposeUp();
            return true;
        }
        if (this.checkTransposeDownKey(pKeyCode, pScanCode)) {
            this.transposeDown();
            return true;
        }
        return false;
    }

    protected boolean checkTransposeDown(int pKeyCode, int pScanCode) {
        if (!this.pitchChanged) {
            return false;
        }
        if (this.checkTransposeUpKey(pKeyCode, pScanCode) || this.checkTransposeDownKey(pKeyCode, pScanCode)) {
            this.resetTransposition();
            return true;
        }
        return false;
    }

    public void transposeUp() {
        this.setPitch(this.getPitch() + 1);
        this.pitchChanged = true;
    }

    public void transposeDown() {
        this.setPitch(this.getPitch() - 1);
        this.pitchChanged = true;
    }

    public void resetTransposition() {
        this.resetPitch();
        this.pitchChanged = false;
    }

    public boolean isTransposed() {
        return this.pitchChanged;
    }

    public boolean isKeyConsumed(int keyCode, int scanCode) {
        return this.getNoteByKey(keyCode) != null || this.checkTransposeDownKey(keyCode, scanCode) || this.checkTransposeUpKey(keyCode, scanCode);
    }

    protected boolean checkTransposeDownKey(int keyCode, int scanCode) {
        return ((KeyMapping)InstrumentKeyMappings.TRANSPOSE_DOWN_MODIFIER.get()).matches(keyCode, scanCode);
    }

    protected boolean checkTransposeUpKey(int keyCode, int scanCode) {
        return ((KeyMapping)InstrumentKeyMappings.TRANSPOSE_UP_MODIFIER.get()).matches(keyCode, scanCode);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.unlockFocused();
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public NoteButton getNoteByKey(int keyCode) {
        InputConstants.Key key = InputConstants.Type.KEYSYM.getOrCreate(keyCode);
        return this.noteMap().getOrDefault(key, null);
    }

    private void unlockFocused() {
        if (this.getFocused() != null && this.getFocused() instanceof NoteButton) {
            ((NoteButton)this.getFocused()).release();
            this.setFocused(null);
        }
    }

    public boolean isOptionsScreenActive() {
        return this.isOptionsScreenActive;
    }

    public void onOptionsOpen() {
        this.setFocused(null);
        this.minecraft.pushGuiLayer((Screen)this.optionsScreen);
        this.resetPitch();
        this.isOptionsScreenActive = true;
    }

    public void onOptionsClose() {
        this.isOptionsScreenActive = false;
    }

    public final void onClose() {
        this.onClose(true);
    }

    public void onClose(boolean notify) {
        if (!this.closed) {
            if (notify) {
                this.notifyClosed();
            }
            if (this.isOptionsScreenActive) {
                this.optionsScreen.onClose();
            }
            this.closed = true;
        }
        super.onClose();
    }

    public void removed() {
        if (!this.closed) {
            this.notifyClosed();
            if (this.isOptionsScreenActive) {
                this.optionsScreen.saveOptions();
            }
            this.closed = true;
        }
        super.removed();
    }

    private void notifyClosed() {
        InstrumentOpenProvider.setClosed((Player)this.minecraft.player);
        GIPacketHandler.sendToServer(CloseInstrumentPacket.INSTANCE);
    }

    public static Optional<InstrumentScreen> getCurrentScreen(Minecraft minecraft) {
        if (minecraft.screen instanceof InstrumentScreen) {
            return Optional.of((InstrumentScreen)minecraft.screen);
        }
        Screen screen = minecraft.screen;
        if (screen instanceof AbstractInstrumentOptionsScreen) {
            AbstractInstrumentOptionsScreen instrumentOptionsScreen = (AbstractInstrumentOptionsScreen)screen;
            return instrumentOptionsScreen.instrumentScreen;
        }
        return Optional.empty();
    }

    public static Optional<InstrumentScreen> getCurrentScreen() {
        return InstrumentScreen.getCurrentScreen(Minecraft.getInstance());
    }

    public boolean isPauseScreen() {
        return false;
    }
}

