/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.grid.NoteGridButton;
import com.cstav.genshinstrument.sound.NoteSound;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.gui.layouts.AbstractLayout;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class NoteGrid
implements Iterable<NoteGridButton> {
    public final GridInstrumentScreen instrumentScreen;
    protected final NoteGridButton[][] notes;
    private NoteSound[] noteSounds;
    public final int rows;
    public final int columns;

    public static int getPaddingHorz() {
        return 9;
    }

    public static int getPaddingVert() {
        return 7;
    }

    public NoteGrid(GridInstrumentScreen instrumentScreen, SSTIPitchProvider pitchProvider) {
        this.instrumentScreen = instrumentScreen;
        this.rows = instrumentScreen.rows();
        this.columns = instrumentScreen.columns();
        this.noteSounds = instrumentScreen.getInitSounds();
        this.notes = new NoteGridButton[this.columns][this.rows];
        for (int i = 0; i < this.columns; ++i) {
            NoteGridButton[] buttonRow = new NoteGridButton[this.rows];
            int column = this.getFlippedColumn(i);
            for (int j = 0; j < this.rows; ++j) {
                buttonRow[j] = instrumentScreen.isSSTI() ? instrumentScreen.createNote(j, column, pitchProvider.get(j, i)) : instrumentScreen.createNote(j, column);
            }
            this.notes[i] = buttonRow;
        }
    }

    public NoteGrid(GridInstrumentScreen instrumentScreen) {
        this(instrumentScreen, null);
    }

    public NoteGrid(GridInstrumentScreen instrumentScreen, int beginningNote, int noteSkip) {
        this(instrumentScreen, (row, column) -> beginningNote + noteSkip * (row + column * instrumentScreen.rows()));
    }

    public NoteGrid(GridInstrumentScreen instrumentScreen, int beginningNote) {
        this(instrumentScreen, beginningNote, 1);
    }

    public NoteSound[] getNoteSounds() {
        return this.noteSounds;
    }

    public void setNoteSounds(NoteSound[] noteSounds) {
        this.noteSounds = noteSounds;
        this.forEach(NoteGridButton::updateSoundArr);
    }

    public HashMap<InputConstants.Key, NoteButton> genKeyboardMap(InputConstants.Key[][] keyMap) {
        HashMap<InputConstants.Key, NoteButton> result = new HashMap<InputConstants.Key, NoteButton>(this.rows * this.columns);
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                result.put(keyMap[i][j], this.notes[this.getFlippedColumn(i)][j]);
            }
        }
        return result;
    }

    public AbstractLayout initNoteGridLayout(float vertAlignment, int screenWidth, int screenHeight) {
        GridLayout grid = new GridLayout();
        grid.defaultCellSetting().padding(NoteGrid.getPaddingHorz(), NoteGrid.getPaddingVert());
        GridLayout.RowHelper rowHelper = grid.createRowHelper(this.rows);
        this.forEach(arg_0 -> ((GridLayout.RowHelper)rowHelper).addChild(arg_0));
        grid.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)grid, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (float)0.5f, (float)vertAlignment);
        grid.arrangeElements();
        this.forEach(NoteButton::init);
        return grid;
    }

    public NoteButton getNoteButton(int row, int column) throws IndexOutOfBoundsException {
        return this.notes[column][row];
    }

    public int getFlippedColumn(int column) {
        return NoteGrid.getFlippedColumn(column, this.columns);
    }

    public static int getFlippedColumn(int column, int columns) {
        return columns - 1 - column;
    }

    @Override
    @NotNull
    public Iterator<NoteGridButton> iterator() {
        return new Iterator<NoteGridButton>(){
            private int i;
            private int j;

            @Override
            public boolean hasNext() {
                return this.i < NoteGrid.this.columns;
            }

            @Override
            public NoteGridButton next() {
                NoteGridButton btn = NoteGrid.this.notes[NoteGrid.this.getFlippedColumn(this.i)][this.j];
                if (this.j >= NoteGrid.this.rows - 1) {
                    this.j = 0;
                    ++this.i;
                } else {
                    ++this.j;
                }
                return btn;
            }
        };
    }

    @FunctionalInterface
    public static interface SSTIPitchProvider {
        public int get(int var1, int var2);
    }
}

