/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentThemeLoader;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteRing;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.NoteAnimationController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NoteButtonRenderer {
    protected static final Minecraft MINECRAFT = Minecraft.getInstance();
    private static final double SHARP_MULTIPLIER = 0.9;
    protected static final double NOTE_DUR = 0.15;
    protected static final double NOTE_TARGET_VAL = 9.0;
    public final NoteButton noteButton;
    protected final InstrumentScreen instrumentScreen;
    protected final ResourceLocation rootLocation;
    protected final ResourceLocation accidentalsLocation;
    protected final ResourceLocation notePressedLocation;
    protected final ResourceLocation noteReleasedLocation;
    protected final ResourceLocation noteHoverLocation;
    protected Supplier<ResourceLocation> labelTextureProvider;
    public final NoteAnimationController noteAnimation;
    public boolean foreignPlaying = false;
    protected final ArrayList<NoteRing> rings = new ArrayList();

    protected NoteAnimationController initNoteAnimation() {
        return new NoteAnimationController(0.15, 9.0, this.noteButton);
    }

    public NoteButtonRenderer(NoteButton noteButton, Supplier<ResourceLocation> labelTextureProvider) {
        this.noteButton = noteButton;
        this.labelTextureProvider = labelTextureProvider;
        this.instrumentScreen = noteButton.instrumentScreen;
        this.noteAnimation = this.initNoteAnimation();
        this.rootLocation = this.instrumentScreen.getResourceFromRoot("note");
        this.accidentalsLocation = this.getResourceFromRoot("accidentals.png");
        this.notePressedLocation = this.getResourceFromRoot("note/pressed.png");
        this.noteReleasedLocation = this.getResourceFromRoot("note/released.png");
        this.noteHoverLocation = this.getResourceFromRoot("note/hovered.png");
    }

    protected ResourceLocation getNotePressedLocation() {
        return this.notePressedLocation;
    }

    protected ResourceLocation getNoteReleasedLocation() {
        return this.noteReleasedLocation;
    }

    protected ResourceLocation getNoteHoverLocation() {
        return this.noteHoverLocation;
    }

    public void render(GuiGraphics gui, int mouseX, int mouseY, float partialTick, InstrumentThemeLoader themeLoader) {
        RenderSystem.enableBlend();
        this.rings.removeIf(ring -> !ring.isPlaying());
        this.rings.forEach(ring -> ring.render(gui, themeLoader));
        this.renderNoteButton(gui, themeLoader);
        this.renderNote(gui, themeLoader);
        this.renderLabel(gui, themeLoader);
        this.renderAccidentals(gui, themeLoader);
        this.noteAnimation.update();
    }

    protected void renderNoteButton(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        ResourceLocation noteLocation = this.noteButton.isPlaying() ? (this.foreignPlaying ? this.getNoteHoverLocation() : this.getNotePressedLocation()) : (this.noteButton.isHoveredOrFocused() ? this.getNoteHoverLocation() : this.getNoteReleasedLocation());
        gui.blit(noteLocation, this.noteButton.getX(), this.noteButton.getY(), 0.0f, 0.0f, this.noteButton.getWidth(), this.noteButton.getHeight(), this.noteButton.getWidth(), this.noteButton.getHeight());
    }

    protected void renderNote(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        int noteWidth = this.noteButton.getWidth() / 2;
        int noteHeight = this.noteButton.getHeight() / 2;
        ClientUtil.setShaderColor(this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.notePressed(this.noteButton) : themeLoader.noteReleased(this.noteButton));
        gui.blit(this.labelTextureProvider.get(), this.noteButton.getX() + noteWidth / 2, this.noteButton.getY() + noteHeight / 2, 0.0f, 0.0f, noteWidth, noteHeight, noteWidth, this.noteButton.getHeight() / 2);
        ClientUtil.resetShaderColor();
    }

    protected void renderLabel(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        gui.drawCenteredString(NoteButtonRenderer.MINECRAFT.font, this.noteButton.getMessage(), this.noteButton.getInitX() + this.noteButton.getInitWidth() / 2, this.noteButton.getInitY() + this.noteButton.getInitHeight() / 2 + 7, (this.noteButton.isPlaying() && !this.foreignPlaying ? themeLoader.labelPressed(this.noteButton) : themeLoader.labelReleased(this.noteButton)).getRGB());
    }

    protected void renderAccidentals(GuiGraphics gui, InstrumentThemeLoader themeLoader) {
        RenderSystem.enableBlend();
        switch (this.noteButton.getNotation()) {
            case NONE: {
                break;
            }
            case FLAT: {
                this.renderAccidental(gui, 0);
                break;
            }
            case SHARP: {
                this.renderAccidental(gui, 1);
                break;
            }
            case DOUBLE_FLAT: {
                this.renderAccidental(gui, 0, -6, -3);
                this.renderAccidental(gui, 0, 5, 2);
                break;
            }
            case DOUBLE_SHARP: {
                this.renderAccidental(gui, 2, -1, 0);
            }
        }
    }

    protected void renderAccidental(GuiGraphics gui, int index) {
        this.renderAccidental(gui, index, 0, 0);
    }

    protected void renderAccidental(GuiGraphics gui, int index, int offsetX, int offsetY) {
        double textureMultiplier = (double)this.noteButton.getWidth() * (index == 1 ? 0.9 : 1.0) * 2.0;
        int textureWidth = (int)textureMultiplier;
        int textureHeight = (int)textureMultiplier - 1;
        int spritePartWidth = textureWidth / 3 + 1;
        gui.blit(this.accidentalsLocation, this.noteButton.getX() - 9 + offsetX, this.noteButton.getY() - 5 + offsetY, (float)(spritePartWidth * index), this.noteButton.isPlaying() ? (float)((textureHeight + 1) / 2) : 0.0f, spritePartWidth - 1, textureHeight / 2, textureWidth, textureHeight);
    }

    public void playNoteAnimation(boolean isForeign) {
        this.foreignPlaying = isForeign;
        this.noteAnimation.play(isForeign);
        this.addRing();
    }

    public void addRing() {
        NoteRing ring = new NoteRing(this.noteButton, this.foreignPlaying);
        this.rings.add(ring);
        ring.playAnim();
    }

    public void resetAnimations() {
        this.rings.clear();
        this.noteAnimation.stop();
    }

    protected ResourceLocation getResourceFromRoot(String path) {
        return CommonUtil.getResourceFrom(this.rootLocation, path);
    }
}

