/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation.NoteAnimationController;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeldNoteAnimationController
extends NoteAnimationController {
    private boolean holding;

    public HeldNoteAnimationController(double duration, double targetValue, NoteButton button) {
        super(duration, targetValue, button);
    }

    @Override
    protected void animFrame(double targetTime, double deltaValue) {
        this.dSize = this.holding ? (this.dSize -= deltaValue * 1.5) : (this.dSize += deltaValue * 1.5);
        this.updateButton();
    }

    @Override
    protected void resetAnimVars() {
        super.resetAnimVars();
        if (!this.holding) {
            int size = (int)((double)this.button.instrumentScreen.getNoteSize() - this.targetValue);
            this.button.setWidth(size);
            this.button.setHeight(size);
            this.dSize = size;
            this.button.moveToCenter();
        }
    }

    public void playReleased(boolean isForeign) {
        this.holding = false;
        this.play(isForeign);
    }

    public void playHold(boolean isForeign) {
        this.holding = true;
        this.play(isForeign);
    }

    @Override
    public void stop() {
        this.holding = !this.holding;
        super.stop();
    }
}

