/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.animation;

import com.cstav.genshinstrument.client.AnimationController;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NoteAnimationController
extends AnimationController {
    protected static final double SCALE_FACTOR = 1.5;
    protected double dSize;
    protected NoteButton button;

    public NoteAnimationController(double duration, double targetValue, NoteButton button) {
        super(duration, targetValue);
        this.button = button;
    }

    @Override
    protected void animFrame(double targetTime, double deltaValue) {
        this.dSize = (double)this.getAnimTime() > targetTime / 2.0 ? (this.dSize += deltaValue * 1.5) : (this.dSize -= deltaValue * 1.5);
        this.updateButton();
    }

    protected void updateButton() {
        int size = (int)this.dSize;
        this.button.setWidth(size);
        this.button.setHeight(size);
        this.button.moveToCenter();
    }

    @Override
    protected void resetAnimVars() {
        super.resetAnimVars();
        this.button.setWidth(this.button.instrumentScreen.getNoteSize());
        this.button.setHeight(this.button.instrumentScreen.getNoteSize());
        this.dSize = this.button.instrumentScreen.getNoteSize();
        this.button.setPosition(this.button.getInitX(), this.button.getInitY());
    }

    public void play(boolean isForeign) {
        this.play();
        if (isForeign) {
            this.targetValue /= 1.75;
        }
    }
}

