/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held;

import com.cstav.genshinstrument.client.gui.screen.instrument.partial.IHeldInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.held.HeldNoteButtonRenderer;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface IHoldableNoteButton {
    public boolean isHeld();

    public void setHeld(boolean var1);

    public HeldNoteSound getHeldNoteSound();

    public void setHeldNoteSound(HeldNoteSound var1);

    public boolean releaseAnimationPlayable();

    default public void releaseHeld(int notePitch, boolean targetPitch, HeldNoteSound heldSound) {
        InitiatorID initiatorId = InitiatorID.fromEntity((Entity)Minecraft.getInstance().player);
        if (targetPitch) {
            HeldNoteSounds.release(initiatorId, heldSound, notePitch);
            this.sendNoteHeldPacket(heldSound, notePitch, HeldSoundPhase.RELEASE);
        } else {
            HeldNoteSounds.release(initiatorId, heldSound).stream().map(soundInstance -> soundInstance.notePitch).distinct().forEach(instPitch -> this.sendNoteHeldPacket(heldSound, (int)instPitch, HeldSoundPhase.RELEASE));
        }
        this.playReleaseAnimation(false);
    }

    default public void releaseHeld(int notePitch, boolean targetPitch) {
        this.releaseHeld(notePitch, targetPitch, this.getHeldNoteSound());
    }

    default public void releaseHeld(boolean targetPitch) {
        this.releaseHeld(this.asNoteBtn().getPitch(), targetPitch);
    }

    default public void playAttackAnimation(boolean isForeign) {
        this.setHeld(true);
        this.asNoteBtn().getRenderer().playNoteAnimation(isForeign);
    }

    default public void playReleaseAnimation(boolean isForeign) {
        HeldNoteButtonRenderer renderer = (HeldNoteButtonRenderer)this.asNoteBtn().getRenderer();
        boolean bl = renderer.foreignPlaying = !isForeign;
        if (!this.releaseAnimationPlayable()) {
            return;
        }
        this.setHeld(false);
        renderer.playRelease();
    }

    default public void playLocalHeldSound(NoteSound sound, int pitch) {
        this.playAttackAnimation(false);
        InstrumentScreen screen = this.asNoteBtn().instrumentScreen;
        this.toHeldSound(sound).startPlaying(pitch, screen.volume(), screen.getInstrumentId());
    }

    default public void sendNoteHeldPacket(HeldNoteSound sound, int pitch, HeldSoundPhase phase) {
        GIPacketHandler.sendToServer(new C2SHeldNoteSoundPacket(this.asNoteBtn(), sound, pitch, phase));
    }

    default public void sendNoteHeldPacket(NoteSound sound, int pitch, HeldSoundPhase phase) {
        this.sendNoteHeldPacket(this.toHeldSound(sound), pitch, phase);
    }

    default public HeldNoteSound toHeldSound(NoteSound noteSound) {
        return Arrays.stream(this.heldInstrumentScreen().getHeldNoteSounds()).filter(heldSound -> heldSound.attack().equals(noteSound)).findFirst().orElseThrow();
    }

    default public NoteButton asNoteBtn() {
        return (NoteButton)((Object)this);
    }

    default public IHeldInstrumentScreen heldInstrumentScreen() {
        return (IHeldInstrumentScreen)((Object)this.asNoteBtn().instrumentScreen);
    }
}

