/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.util.CommonUtil;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MidiOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final int MIN_OCTAVE_SHIFT = -5;
    public static final int MAX_OCTAVE_SHIFT = 5;
    public static final int MIN_MIDI_CHANNEL = 0;
    public static final int MAX_MIDI_CHANNEL = 15;

    public MidiOptionsScreen(Component pTitle, Screen prevScreen, InstrumentScreen instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    public MidiOptionsScreen(Component pTitle, Screen prevScreen, Optional<InstrumentScreen> instrumentScreen) {
        super(pTitle, instrumentScreen, prevScreen);
    }

    protected void init() {
        GridLayout grid = new GridLayout();
        grid.defaultCellSetting().padding(4, 2).alignVertically(0.5f).alignHorizontallyCenter();
        this.initOptionsGrid(grid, grid.createRowHelper(2));
        ClientUtil.alignGrid((Layout)grid, this.width, this.height);
        grid.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        Button doneBtn = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).width(150).pos((this.width - 150) / 2, ClientUtil.lowerButtonsY(grid.getY(), grid.getHeight(), this.height)).build();
        this.addRenderableWidget((GuiEventListener)doneBtn);
    }

    protected void initDeviceSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        CycleButton midiEnabled = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.MIDI_ENABLED.get())).create(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.midiEnabled"), this::onMidiEnabledChanged);
        rowHelper.addChild((LayoutElement)midiEnabled, 2);
        SliderButton inputSensitivity = new SliderButton(this.getSmallButtonWidth(), (Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get(), 0.0, 1.0){
            private static final DecimalFormat D_FORMAT = new DecimalFormat("0.0");

            @Override
            public Component getMessage() {
                return Component.translatable((String)"button.genshinstrument.inputSensitivity").append(": " + D_FORMAT.format((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get() * 100.0) + "%");
            }

            protected void applyValue() {
                MidiOptionsScreen.this.onMidiSensitivityChanged(this, this.value);
            }
        };
        CycleButton fixedTouch = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.FIXED_TOUCH.get())).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"button.genshinstrument.fixedTouch.tooltip"))).create(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.fixedTouch"), (btn, val) -> {
            this.onFixedTouchChanged((CycleButton<Boolean>)btn, (boolean)val);
            inputSensitivity.active = val == false;
        });
        inputSensitivity.active = (Boolean)ModClientConfigs.FIXED_TOUCH.get() == false;
        rowHelper.addChild((LayoutElement)fixedTouch);
        rowHelper.addChild((LayoutElement)inputSensitivity);
        MidiController.reloadDevices();
        CycleButton midiDevice = CycleButton.builder(value -> {
            if (value == -1) {
                return Component.translatable((String)"button.none");
            }
            return Component.literal((String)MidiController.infoAsString(MidiController.getInfoFromIndex(value)));
        }).withValues(MidiOptionsScreen.getMidiDevicesRange()).withInitialValue((Object)((Integer)ModClientConfigs.MIDI_DEVICE_INDEX.get())).create(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.midiDevice"), this::onMidiDeviceChanged);
        rowHelper.addChild((LayoutElement)midiDevice, 2);
    }

    protected void initThatOtherSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        boolean canInstrumentOverflow = this.instrumentScreen.map(screen -> screen.midiReceiver.allowMidiOverflow()).orElse(false);
        if (canInstrumentOverflow) {
            CycleButton extendOctaves = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.EXTEND_OCTAVES.get())).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"button.genshinstrument.extendOctaves.tooltip"))).create(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.extendOctaves"), this::onExtendOctavesChanged);
            rowHelper.addChild((LayoutElement)extendOctaves);
        }
        SliderButton octaveShift = new SliderButton(canInstrumentOverflow ? this.getSmallButtonWidth() : this.getBigButtonWidth(), ((Integer)ModClientConfigs.OCTAVE_SHIFT.get()).intValue(), -5.0, 5.0){

            @Override
            public Component getMessage() {
                return Component.translatable((String)"button.genshinstrument.midiOctaveShift").append(": " + String.valueOf(ModClientConfigs.OCTAVE_SHIFT.get()));
            }

            protected void applyValue() {
                MidiOptionsScreen.this.onOctaveShiftChanged(this, (int)this.getValueClamped());
            }
        };
        rowHelper.addChild((LayoutElement)octaveShift, canInstrumentOverflow ? 1 : 2);
        SliderButton midiChannel = new SliderButton(this.getSmallButtonWidth(), ((Integer)ModClientConfigs.MIDI_CHANNEL.get()).intValue(), 0.0, 15.0){

            @Override
            public Component getMessage() {
                return Component.translatable((String)"button.genshinstrument.midiChannel").append(": " + String.valueOf(ModClientConfigs.MIDI_CHANNEL.get()));
            }

            protected void applyValue() {
                MidiOptionsScreen.this.onMidiChannelChanged(this, (int)this.getValueClamped());
            }
        };
        CycleButton acceptAllChannels = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.ACCEPT_ALL_CHANNELS.get())).create(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.acceptAllChannels"), (btn, val) -> {
            this.onAcceptAllChannelsChanged((CycleButton<Boolean>)btn, (boolean)val);
            midiChannel.active = val == false;
        });
        midiChannel.active = (Boolean)acceptAllChannels.getValue() == false;
        rowHelper.addChild((LayoutElement)acceptAllChannels);
        rowHelper.addChild((LayoutElement)midiChannel);
    }

    protected void initOptionsGrid(GridLayout grid, GridLayout.RowHelper rowHelper) {
        this.initDeviceSection(grid, rowHelper);
        rowHelper.addChild((LayoutElement)SpacerElement.height((int)7), 2);
        this.initThatOtherSection(grid, rowHelper);
    }

    public static List<Integer> getMidiDevicesRange() {
        return IntStream.range(-1, MidiController.DEVICES.size()).boxed().toList();
    }

    protected void onMidiEnabledChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.MIDI_ENABLED.set((Object)value);
        MidiController.loadByConfigs();
    }

    protected void onMidiDeviceChanged(CycleButton<Integer> button, int value) {
        ModClientConfigs.MIDI_DEVICE_INDEX.set((Object)value);
        MidiController.loadByConfigs();
    }

    protected void onExtendOctavesChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.EXTEND_OCTAVES.set((Object)value);
    }

    protected void onOctaveShiftChanged(AbstractSliderButton button, int value) {
        if ((Integer)ModClientConfigs.OCTAVE_SHIFT.get() != value) {
            ModClientConfigs.OCTAVE_SHIFT.set((Object)value);
        }
    }

    protected void onFixedTouchChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.FIXED_TOUCH.set((Object)value);
    }

    protected void onMidiSensitivityChanged(AbstractSliderButton button, double value) {
        value = CommonUtil.round(value, 3);
        if ((Double)ModClientConfigs.MIDI_IN_SENSITIVITY.get() != value) {
            ModClientConfigs.MIDI_IN_SENSITIVITY.set((Object)value);
        }
    }

    protected void onAcceptAllChannelsChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.ACCEPT_ALL_CHANNELS.set((Object)value);
    }

    protected void onMidiChannelChanged(AbstractSliderButton button, int value) {
        if ((Integer)ModClientConfigs.MIDI_CHANNEL.get() != value) {
            ModClientConfigs.MIDI_CHANNEL.set((Object)value);
        }
    }
}

