/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractInstrumentOptionsScreen
extends Screen {
    public final Optional<InstrumentScreen> instrumentScreen;
    public final Screen lastScreen;
    public final boolean isOverlay;
    protected final HashMap<String, Runnable> appliedOptions = new HashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    public AbstractInstrumentOptionsScreen(Component pTitle, InstrumentScreen instrumentScreen, Screen lastScreen) {
        super(pTitle);
        this.instrumentScreen = Optional.ofNullable(instrumentScreen);
        this.lastScreen = lastScreen;
        this.isOverlay = instrumentScreen != null;
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Optional<InstrumentScreen> instrumentScreen, Screen lastScreen) {
        this(pTitle, (InstrumentScreen)instrumentScreen.orElse(null), lastScreen);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, InstrumentScreen instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Optional<InstrumentScreen> instrumentScreen) {
        this(pTitle, instrumentScreen, null);
    }

    public AbstractInstrumentOptionsScreen(Component pTitle, Screen prevScreen) {
        this(pTitle, Optional.empty(), prevScreen);
    }

    public int getSmallButtonWidth() {
        return 190;
    }

    public int getBigButtonWidth() {
        return (this.getSmallButtonWidth() + 4) * 2;
    }

    public int getButtonHeight() {
        return 20;
    }

    public void render(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(gui, pMouseX, pMouseY, pPartialTick);
        gui.drawCenteredString(this.font, this.title, this.width / 2, 15, Color.WHITE.getRGB());
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        this.instrumentScreen.ifPresent(screen -> {
            if (screen.isKeyConsumed(pKeyCode, pScanCode)) {
                screen.keyPressed(pKeyCode, pScanCode, pModifiers);
            }
        });
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        this.instrumentScreen.ifPresent(screen -> {
            if (screen.isKeyConsumed(pKeyCode, pScanCode)) {
                screen.keyReleased(pKeyCode, pScanCode, pModifiers);
            }
        });
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean isPauseScreen() {
        return !this.isOverlay;
    }

    public void onClose() {
        this.saveOptions();
        if (this.isOverlay) {
            super.onClose();
            if (this.lastScreen != null) {
                this.minecraft.pushGuiLayer(this.lastScreen);
            }
        } else if (this.lastScreen != null) {
            this.minecraft.setScreen(this.lastScreen);
        } else {
            super.onClose();
        }
    }

    protected void queueToSave(String optionKey, Runnable saveRunnable) {
        String modId = this.modId();
        if (modId != null) {
            optionKey = modId + ":" + (String)optionKey;
        }
        if (this.appliedOptions.containsKey(optionKey)) {
            this.appliedOptions.replace((String)optionKey, saveRunnable);
        } else {
            this.appliedOptions.put((String)optionKey, saveRunnable);
        }
    }

    public void saveOptions() {
        if (this.appliedOptions.isEmpty()) {
            return;
        }
        this.appliedOptions.values().forEach(Runnable::run);
        ModClientConfigs.CONFIGS.save();
        LOGGER.info("Successfully saved " + this.appliedOptions.size() + " option(s) for " + this.title.getString());
    }

    public String modId() {
        return this.instrumentScreen.map(InstrumentScreen::getModId).orElse(null);
    }
}

