/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.screen.options.instrument.partial;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.config.enumType.InstrumentChannelType;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.grid.GridInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.NoteButton;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.note.label.INoteLabel;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.MidiOptionsScreen;
import com.cstav.genshinstrument.client.gui.screen.options.instrument.partial.AbstractInstrumentOptionsScreen;
import com.cstav.genshinstrument.client.gui.widget.SliderButton;
import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.util.CommonUtil;
import com.cstav.genshinstrument.util.LabelUtil;
import java.text.DecimalFormat;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class InstrumentOptionsScreen
extends AbstractInstrumentOptionsScreen {
    public static final MutableComponent MIDI_OPTIONS = Component.translatable((String)"label.genshinstrument.midiOptions");
    private static final String SOUND_CHANNEL_KEY = "button.genshinstrument.audioChannels";
    private static final String STOP_MUSIC_KEY = "button.genshinstrument.stop_music_on_play";
    @Nullable
    protected final INoteLabel[] labels = this.getLabels();
    @Nullable
    protected INoteLabel currLabel;

    public abstract INoteLabel[] getLabels();

    public abstract INoteLabel getCurrentLabel();

    public boolean isPitchSliderEnabled() {
        return true;
    }

    public InstrumentOptionsScreen(@Nullable InstrumentScreen screen) {
        super((Component)Component.translatable((String)"button.genshinstrument.instrumentOptions"), screen);
    }

    public InstrumentOptionsScreen(Screen lastScreen) {
        super((Component)Component.translatable((String)"button.genshinstrument.instrumentOptions"), lastScreen);
    }

    protected void init() {
        this.currLabel = this.getCurrentLabel();
        GridLayout grid = ClientUtil.createSettingsGrid();
        this.initOptionsGrid(grid, grid.createRowHelper(2));
        grid.arrangeElements();
        ClientUtil.alignGrid((Layout)grid, this.width, this.height);
        grid.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        int buttonsY = ClientUtil.lowerButtonsY(grid.getY(), grid.getHeight(), this.height);
        int buttonsWidth = 150;
        Button doneBtn = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).width(150).build();
        if (!this.isOverlay || ((InstrumentScreen)((Object)this.instrumentScreen.get())).isMidiInstrument()) {
            LinearLayout buttonLayout = new LinearLayout(grid.getX() + this.getSmallButtonWidth() - 150 + 4, buttonsY, LinearLayout.Orientation.HORIZONTAL);
            buttonLayout.spacing(8);
            Button midiOptions = Button.builder((Component)MIDI_OPTIONS.copy().append("..."), btn -> this.openMidiOptions()).width(150).build();
            buttonLayout.addChild((LayoutElement)midiOptions);
            buttonLayout.addChild((LayoutElement)doneBtn);
            buttonLayout.arrangeElements();
            buttonLayout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
        } else {
            doneBtn.setPosition((this.width - doneBtn.getWidth()) / 2, buttonsY);
            this.addRenderableWidget((GuiEventListener)doneBtn);
        }
    }

    protected void initAudioSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        CycleButton instrumentChannel = CycleButton.builder(soundType -> Component.translatable((String)("button.genshinstrument.audioChannels." + soundType.getKey()))).withValues((Object[])InstrumentChannelType.values()).withInitialValue((Object)((InstrumentChannelType)((Object)ModClientConfigs.CHANNEL_TYPE.get()))).withTooltip(soundType -> Tooltip.create((Component)(switch (soundType) {
            case InstrumentChannelType.MIXED -> InstrumentOptionsScreen.translatableArgs("button.genshinstrument.audioChannels.mixed.tooltip", 5.5);
            case InstrumentChannelType.STEREO -> Component.translatable((String)"button.genshinstrument.audioChannels.stereo.tooltip");
            default -> CommonComponents.EMPTY;
        }))).create(0, 0, this.getBigButtonWidth(), 20, (Component)Component.translatable((String)SOUND_CHANNEL_KEY), this::onChannelTypeChanged);
        rowHelper.addChild((LayoutElement)instrumentChannel, 2);
        if (this.isPitchSliderEnabled()) {
            SliderButton pitchSlider = new SliderButton(this.getSmallButtonWidth(), this.getPitch(), NoteSound.MIN_PITCH, NoteSound.MAX_PITCH){
                private static final DecimalFormat D_FORMAT = new DecimalFormat("0.00");
                private int pitch;
                {
                    this.pitch = InstrumentOptionsScreen.this.getPitch();
                }

                @Override
                public Component getMessage() {
                    return Component.translatable((String)"button.genshinstrument.pitch").append(": " + LabelUtil.formatNoteName(LabelUtil.getNoteName(this.pitch, GridInstrumentScreen.NOTE_LAYOUT, 0), false) + " (" + D_FORMAT.format(NoteSound.getPitchByNoteOffset(this.pitch)) + ")");
                }

                protected void applyValue() {
                    this.pitch = (int)this.getValueClamped();
                    InstrumentOptionsScreen.this.onPitchChanged(this, this.pitch);
                }
            };
            rowHelper.addChild((LayoutElement)pitchSlider);
        }
        SliderButton volumeSlider = new SliderButton(this.getSmallButtonWidth(), this.getVolume(), 0.0, 1.0){

            @Override
            public Component getMessage() {
                return Component.translatable((String)"button.genshinstrument.volume").append(": " + (int)(this.value * 100.0) + "%");
            }

            protected void applyValue() {
                InstrumentOptionsScreen.this.onVolumeChanged(this, this.value);
            }
        };
        rowHelper.addChild((LayoutElement)volumeSlider);
    }

    protected void initVisualsSection(GridLayout grid, GridLayout.RowHelper rowHelper) {
        CycleButton stopMusic = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.STOP_MUSIC_ON_PLAY.get())).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"button.genshinstrument.stop_music_on_play.tooltip", (Object[])new Object[]{10.0}))).create(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)STOP_MUSIC_KEY), this::onMusicStopChanged);
        rowHelper.addChild((LayoutElement)stopMusic);
        CycleButton sharedInstrument = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get())).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"button.genshinstrument.shared_instrument.tooltip"))).create(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.shared_instrument"), this::onSharedInstrumentChanged);
        rowHelper.addChild((LayoutElement)sharedInstrument);
        CycleButton accurateNotes = CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON, (Component)CommonComponents.OPTION_OFF).withInitialValue((Object)((Boolean)ModClientConfigs.ACCURATE_NOTES.get())).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)"button.genshinstrument.accurate_notes.tooltip"))).create(0, 0, this.getSmallButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.accurate_notes"), this::onAccurateNotesChanged);
        rowHelper.addChild((LayoutElement)accurateNotes);
        if (this.labels != null) {
            CycleButton labelType = CycleButton.builder(label -> Component.translatable((String)label.getKey())).withValues((Object[])this.labels).withInitialValue((Object)this.currLabel).withTooltip(value -> Tooltip.create((Component)Component.translatable((String)(value.getKey() + ".description")))).create(0, 0, this.getBigButtonWidth(), this.getButtonHeight(), (Component)Component.translatable((String)"button.genshinstrument.label"), this::onLabelChanged);
            rowHelper.addChild((LayoutElement)labelType, 2);
        }
    }

    protected void initOptionsGrid(GridLayout grid, GridLayout.RowHelper rowHelper) {
        this.initAudioSection(grid, rowHelper);
        rowHelper.addChild((LayoutElement)SpacerElement.height((int)7), 2);
        this.initVisualsSection(grid, rowHelper);
    }

    private int getPitch() {
        return this.instrumentScreen.map(InstrumentScreen::getPitch).orElseGet((Supplier<Integer>)ModClientConfigs.PITCH);
    }

    private double getVolume() {
        return this.instrumentScreen.map(screen -> screen.volume()).orElseGet((Supplier<Double>)ModClientConfigs.VOLUME);
    }

    protected void onPitchChanged(AbstractSliderButton slider, int pitch) {
        this.instrumentScreen.ifPresentOrElse(screen -> {
            if (screen.getPitch() == pitch) {
                return;
            }
            screen.setPitch(pitch);
            this.savePitch(pitch);
        }, () -> this.queueToSave("pitch", () -> this.savePitch(pitch)));
    }

    protected void savePitch(int newPitch) {
        ModClientConfigs.PITCH.set((Object)newPitch);
    }

    protected void onVolumeChanged(AbstractSliderButton slider, double volume) {
        int newVolume = (int)(volume * 100.0);
        this.instrumentScreen.ifPresent(screen -> {
            screen.volume = newVolume;
        });
        this.queueToSave("volume", () -> this.saveVolume((double)newVolume / 100.0));
    }

    protected void saveVolume(double newVolume) {
        ModClientConfigs.VOLUME.set((Object)CommonUtil.round(newVolume, 4));
    }

    protected void onLabelChanged(CycleButton<INoteLabel> button, INoteLabel label) {
        this.instrumentScreen.ifPresent(screen -> screen.setLabelSupplier(label.getLabelSupplier()));
        this.saveLabel(label);
    }

    protected abstract void saveLabel(INoteLabel var1);

    protected void onChannelTypeChanged(CycleButton<InstrumentChannelType> button, InstrumentChannelType type) {
        ModClientConfigs.CHANNEL_TYPE.set((Object)type);
    }

    protected void onMusicStopChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.STOP_MUSIC_ON_PLAY.set((Object)value);
    }

    protected void onSharedInstrumentChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.SHARED_INSTRUMENT.set((Object)value);
    }

    protected void onAccurateNotesChanged(CycleButton<Boolean> button, boolean value) {
        ModClientConfigs.ACCURATE_NOTES.set((Object)value);
        this.instrumentScreen.ifPresent(screen -> screen.notesIterable().forEach(NoteButton::updateNoteLabel));
    }

    protected void openMidiOptions() {
        if (this.isOverlay) {
            this.minecraft.popGuiLayer();
            this.minecraft.pushGuiLayer((Screen)this.midiOptionsScreen());
        } else {
            this.minecraft.setScreen((Screen)this.midiOptionsScreen());
        }
    }

    protected MidiOptionsScreen midiOptionsScreen() {
        return new MidiOptionsScreen((Component)MIDI_OPTIONS, (Screen)this, this.instrumentScreen);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.instrumentScreen.ifPresent(InstrumentScreen::onOptionsClose);
    }

    private static MutableComponent translatableArgs(String key, Object arg) {
        return Component.literal((String)Component.translatable((String)key).getString().replace("%s", arg.toString()));
    }
}

