/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.gui.widget;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;

public class IconToggleButton
extends Button {
    private static final int ICON_MARGIN = 1;
    protected boolean enabled = false;
    private final ResourceLocation iconEnabled;
    private final ResourceLocation iconDisabled;

    public IconToggleButton(int x, int y, int size, ResourceLocation iconEnabled, ResourceLocation iconDisabled, Button.OnPress onPress) {
        super(new Button.Builder(CommonComponents.EMPTY, onPress).pos(x, y));
        this.width = this.height = size;
        this.iconDisabled = iconDisabled;
        this.iconEnabled = iconEnabled;
    }

    public IconToggleButton(int x, int y, ResourceLocation iconEnabled, ResourceLocation iconDisabled, Button.OnPress onPress) {
        this(x, y, 20, iconEnabled, iconDisabled, onPress);
    }

    public IconToggleButton(int x, int y, ResourceLocation iconEnabled, ResourceLocation iconDisabled) {
        this(x, y, iconEnabled, iconDisabled, idc -> {});
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void toggle() {
        this.setEnabled(!this.enabled);
    }

    protected void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        int size = this.getHeight() - 1;
        pGuiGraphics.blit(this.enabled ? this.iconEnabled : this.iconDisabled, this.getX() + 1, this.getY() + 1, 0.0f, 0.0f, size, size, size, size);
    }

    public void onPress() {
        this.toggle();
        super.onPress();
    }
}

