/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.client.util;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.keyMaps.InstrumentKeyMappings;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.Lazy;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtil {
    public static final int GRID_HORZ_PADDING = 4;
    public static final int GRID_VERT_PADDING = 2;
    public static final double STOP_SOUND_DISTANCE = 10.0;
    public static final Lazy<Boolean> ON_QWERTY = Lazy.of(() -> {
        String qwerty = "QWERTY";
        InputConstants.Key[] keyRow = InstrumentKeyMappings.GRID_INSTRUMENT_MAPPINGS[0];
        for (int i = 0; i < "QWERTY".length(); ++i) {
            if (ClientUtil.charEquals("QWERTY".charAt(i), keyRow[i].getDisplayName().getString(1).charAt(0))) continue;
            return false;
        }
        return true;
    });

    public static boolean stopMusicIfClose(double playDistSqr) {
        if (((Boolean)ModClientConfigs.STOP_MUSIC_ON_PLAY.get()).booleanValue() && playDistSqr < Mth.square((double)10.0)) {
            Minecraft.getInstance().getMusicManager().stopPlaying();
            return true;
        }
        return false;
    }

    public static boolean stopMusicIfClose(BlockPos pos) {
        return ClientUtil.stopMusicIfClose(pos.getCenter().distanceToSqr(Minecraft.getInstance().player.position()));
    }

    private static boolean charEquals(char char1, char char2) {
        return Character.toLowerCase(char1) == Character.toLowerCase(char2);
    }

    public static Point getInitCenter(int initX, int initY, int initSize, int currSize) {
        return new Point((initSize - currSize) / 2 + initX, (initSize - currSize) / 2 + initY);
    }

    public static void setShaderColor(Color color, float alpha) {
        RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)alpha);
    }

    public static void setShaderColor(Color color) {
        ClientUtil.setShaderColor(color, 1.0f);
    }

    public static void resetShaderColor() {
        ClientUtil.setShaderColor(Color.WHITE);
    }

    public static GridLayout createSettingsGrid() {
        GridLayout grid = new GridLayout();
        grid.defaultCellSetting().padding(4, 2).alignVertically(0.5f).alignHorizontallyCenter();
        return grid;
    }

    public static void alignGrid(Layout layout, int screenWidth, int screenHeight) {
        layout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)layout, (int)0, (int)0, (int)screenWidth, (int)screenHeight, (float)0.5f, (float)0.0f);
        layout.setY(30);
        layout.arrangeElements();
    }

    public static int lowerButtonsY(int desiredY, int desiredHeight, int screenHeight) {
        return Math.min(desiredY + desiredHeight + 50, screenHeight - 20 - 15);
    }
}

