/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.block.partial.AbstractInstrumentBlock;
import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.IHeldInstrumentScreen;
import com.cstav.genshinstrument.client.gui.screen.instrument.partial.InstrumentScreen;
import com.cstav.genshinstrument.client.midi.MidiController;
import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.event.InstrumentPlayedEvent;
import com.cstav.genshinstrument.event.MidiEvent;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.ReqInstrumentOpenStatePacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.GameShuttingDownEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="genshinstrument", value={Dist.CLIENT})
public class ClientEvents {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        InstrumentScreen.getCurrentScreen(MINECRAFT).ifPresent(InstrumentScreen::handleAbruptClosing);
    }

    @SubscribeEvent
    public static void prePlayerRenderEvent(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!InstrumentOpenProvider.isOpen(player) || InstrumentOpenProvider.isItem(player)) {
            return;
        }
        Block block = player.level().getBlockState(InstrumentOpenProvider.getBlockPos(player)).getBlock();
        if (!(block instanceof AbstractInstrumentBlock)) {
            return;
        }
        AbstractInstrumentBlock instrumentBlock = (AbstractInstrumentBlock)block;
        PlayerModel model = (PlayerModel)event.getRenderer().getModel();
        model.leftArmPose = model.rightArmPose = instrumentBlock.getClientBlockArmPose();
    }

    @SubscribeEvent
    public static void onInstrumentPlayed(InstrumentPlayedEvent<?> event) {
        if (!ClientEvents.validateSharedScreen(event)) {
            return;
        }
        if (!event.soundMeta().pos().closerThan((Vec3i)ClientEvents.MINECRAFT.player.blockPosition(), 5.5)) {
            return;
        }
        ClientEvents.foreignPlayableInstrumentScreen(event).ifPresent(screen -> screen.foreignPlay(event));
    }

    @SubscribeEvent
    public static void onHeldNoteSound(HeldNoteSoundPlayedEvent event) {
        if (event.phase != HeldSoundPhase.RELEASE) {
            return;
        }
        if (!ClientEvents.validateSharedScreen(event)) {
            return;
        }
        ClientEvents.foreignPlayableInstrumentScreen(event).filter(screen -> screen instanceof IHeldInstrumentScreen).map(screen -> (IHeldInstrumentScreen)((Object)screen)).ifPresent(screen -> screen.releaseForeign(event));
    }

    private static boolean validateSharedScreen(InstrumentPlayedEvent<?> event) {
        Entity initiator;
        if (!event.level().isClientSide) {
            return false;
        }
        if (!((Boolean)ModClientConfigs.SHARED_INSTRUMENT.get()).booleanValue()) {
            return false;
        }
        return !event.isByPlayer() || !(initiator = event.entityInfo().get().entity).equals((Object)ClientEvents.MINECRAFT.player);
    }

    private static Optional<InstrumentScreen> foreignPlayableInstrumentScreen(InstrumentPlayedEvent<?> event) {
        return InstrumentScreen.getCurrentScreen(MINECRAFT).filter(screen -> event.soundMeta().noteIdentifier().isEmpty() || screen.getInstrumentId().equals((Object)event.soundMeta().instrumentId()));
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof RemotePlayer) {
            RemotePlayer player = (RemotePlayer)entity;
            GIPacketHandler.sendToServer(new ReqInstrumentOpenStatePacket(player.getUUID()));
        }
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        HeldNoteSounds.releaseAll();
    }

    @SubscribeEvent
    public static void onMidiEvent(MidiEvent event) {
        InstrumentScreen.getCurrentScreen(Minecraft.getInstance()).filter(InstrumentScreen::isMidiInstrument).ifPresent(instrument -> instrument.midiReceiver.onMidi(event));
    }

    @SubscribeEvent
    public static void onGameShutdown(GameShuttingDownEvent event) {
        MidiController.unloadDevice();
    }
}

