/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.event;

import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.item.InstrumentItem;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import com.cstav.genshinstrument.util.ServerUtil;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;

@EventBusSubscriber(modid="genshinstrument")
public abstract class ServerEvents {
    private static final int MAX_BLOCK_INSTRUMENT_DIST = 6;

    @SubscribeEvent
    public static void onServerTick(LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide) {
            event.getLevel().players().forEach(player -> {
                if (ServerEvents.shouldAbruptlyClose(player)) {
                    InstrumentPacketUtil.setInstrumentClosed((ServerPlayer)player);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        InstrumentPacketUtil.setInstrumentClosed((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerUtil.notifyOpenStateToPlayers((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onDimensionChangedEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerUtil.notifyOpenStateToPlayers((ServerPlayer)event.getEntity());
    }

    private static boolean shouldAbruptlyClose(Player player) {
        if (!InstrumentOpenProvider.isOpen(player)) {
            return false;
        }
        if (InstrumentOpenProvider.isItem(player)) {
            InteractionHand hand = InstrumentOpenProvider.getHand(player);
            if (hand == null) {
                return true;
            }
            ItemStack handItem = player.getItemInHand(hand);
            return !(handItem.getItem() instanceof InstrumentItem);
        }
        return !InstrumentOpenProvider.getBlockPos(player).closerToCenterThan((Position)player.position(), 6.0);
    }
}

