/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.item;

import com.cstav.genshinstrument.item.clientExtensions.InstrumentItemClientExt;
import com.cstav.genshinstrument.networking.OpenInstrumentPacketSender;
import com.cstav.genshinstrument.networking.packet.instrument.util.InstrumentPacketUtil;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class InstrumentItem
extends Item {
    protected final OpenInstrumentPacketSender onOpenRequest;

    public InstrumentItem(OpenInstrumentPacketSender onOpenRequest) {
        this(onOpenRequest, new Item.Properties());
    }

    public InstrumentItem(OpenInstrumentPacketSender onOpenRequest, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.onOpenRequest = onOpenRequest;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack item = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            return InteractionResultHolder.success((Object)item);
        }
        if (InstrumentPacketUtil.sendOpenPacket((ServerPlayer)pPlayer, pUsedHand, this.onOpenRequest)) {
            return InteractionResultHolder.success((Object)item);
        }
        return InteractionResultHolder.fail((Object)item);
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.CUSTOM;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new InstrumentItemClientExt());
    }
}

