/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking;

import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.C2SNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.CloseInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.c2s.ReqInstrumentOpenStatePacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.OpenInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.ClientDistExec;
import com.cstav.genshinstrument.util.ServerUtil;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="genshinstrument")
public class GIPacketHandler {
    private static final List<Class<IModPacket>> ACCEPTABLE_PACKETS_C2S = List.of(new Class[]{C2SNoteSoundPacket.class, CloseInstrumentPacket.class, C2SHeldNoteSoundPacket.class, ReqInstrumentOpenStatePacket.class});
    private static final List<Class<IModPacket>> ACCEPTABLE_PACKETS_S2C = List.of(new Class[]{NotifyInstrumentOpenPacket.class, S2CNoteSoundPacket.class, OpenInstrumentPacket.class, S2CHeldNoteSoundPacket.class});
    public static final String PROTOCOL_VERSION = "5.0";
    private static final PayloadRegistrar payloadRegistrar = new PayloadRegistrar("5.0");

    @SubscribeEvent
    public static void onPayloadRegistration(RegisterPayloadHandlersEvent event) {
        ServerUtil.registerC2SPackets(ACCEPTABLE_PACKETS_C2S, payloadRegistrar);
        ServerUtil.registerS2CPackets(ACCEPTABLE_PACKETS_S2C, () -> ClientDistExec.PACKET_SWITCH, payloadRegistrar);
    }

    public static void sendToServer(IModPacket packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToClient(IModPacket packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

