/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.s2c;

import com.cstav.genshinstrument.networking.IModPacket;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;

public class NotifyInstrumentOpenPacket
extends IModPacket {
    public static final String MOD_ID = "genshinstrument";
    public static final StreamCodec<RegistryFriendlyByteBuf, NotifyInstrumentOpenPacket> CODEC = CustomPacketPayload.codec(NotifyInstrumentOpenPacket::write, NotifyInstrumentOpenPacket::new);
    public final UUID playerUUID;
    public final boolean isOpen;
    public final Optional<BlockPos> pos;
    public final Optional<InteractionHand> hand;

    public NotifyInstrumentOpenPacket(UUID playerUUID) {
        this.playerUUID = playerUUID;
        this.isOpen = false;
        this.pos = Optional.empty();
        this.hand = Optional.empty();
    }

    public NotifyInstrumentOpenPacket(UUID playerUUID, BlockPos pos) {
        this.playerUUID = playerUUID;
        this.isOpen = true;
        this.pos = Optional.of(pos);
        this.hand = Optional.empty();
    }

    public NotifyInstrumentOpenPacket(UUID playerUUID, InteractionHand hand) {
        this.playerUUID = playerUUID;
        this.isOpen = true;
        this.pos = Optional.empty();
        this.hand = Optional.of(hand);
    }

    public NotifyInstrumentOpenPacket(FriendlyByteBuf buf) {
        this.playerUUID = buf.readUUID();
        this.isOpen = buf.readBoolean();
        this.pos = buf.readOptional(fbb -> fbb.readBlockPos());
        this.hand = buf.readOptional(fbb -> (InteractionHand)fbb.readEnum(InteractionHand.class));
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeUUID(this.playerUUID);
        buf.writeBoolean(this.isOpen);
        buf.writeOptional(this.pos, (fbb, pos) -> fbb.writeBlockPos(pos));
        buf.writeOptional(this.hand, FriendlyByteBuf::writeEnum);
    }
}

