/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.s2c;

import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNotePacket;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public class S2CHeldNoteSoundPacket
extends S2CNotePacket<HeldNoteSound> {
    public static final String MOD_ID = "genshinstrument";
    public static final StreamCodec<RegistryFriendlyByteBuf, S2CHeldNoteSoundPacket> CODEC = CustomPacketPayload.codec(S2CHeldNoteSoundPacket::write, S2CHeldNoteSoundPacket::new);
    public final HeldSoundPhase phase;
    public final Optional<InitiatorID> oInitiatorID;

    public S2CHeldNoteSoundPacket(Optional<Integer> initiatorID, Optional<InitiatorID> oInitiatorID, HeldNoteSound sound, NoteSoundMetadata meta, HeldSoundPhase phase) {
        super(initiatorID, sound, meta);
        this.phase = phase;
        this.oInitiatorID = oInitiatorID;
    }

    public S2CHeldNoteSoundPacket(FriendlyByteBuf buf) {
        super(buf);
        this.phase = (HeldSoundPhase)buf.readEnum(HeldSoundPhase.class);
        this.oInitiatorID = buf.readOptional(InitiatorID::readFromNetwork);
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        super.write(buf);
        buf.writeEnum((Enum)this.phase);
        buf.writeOptional(this.oInitiatorID, (fbb, initId) -> initId.writeToNetwork((FriendlyByteBuf)fbb));
    }

    @Override
    protected void writeSound(FriendlyByteBuf buf) {
        ((HeldNoteSound)this.sound).writeToNetwork(buf);
    }

    @Override
    protected HeldNoteSound readSound(FriendlyByteBuf buf) {
        return HeldNoteSound.readFromNetwork(buf);
    }
}

