/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.s2c;

import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public abstract class S2CNotePacket<T>
extends IModPacket {
    public final Optional<Integer> initiatorID;
    public final T sound;
    public final NoteSoundMetadata meta;

    public S2CNotePacket(Optional<Integer> initiatorID, T sound, NoteSoundMetadata meta) {
        this.initiatorID = initiatorID;
        this.sound = sound;
        this.meta = meta;
    }

    public S2CNotePacket(FriendlyByteBuf buf) {
        this.initiatorID = buf.readOptional(FriendlyByteBuf::readInt);
        this.sound = this.readSound(buf);
        this.meta = NoteSoundMetadata.read(buf);
    }

    @Override
    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeOptional(this.initiatorID, FriendlyByteBuf::writeInt);
        this.writeSound((FriendlyByteBuf)buf);
        this.meta.write((FriendlyByteBuf)buf);
    }

    protected abstract T readSound(FriendlyByteBuf var1);

    protected abstract void writeSound(FriendlyByteBuf var1);
}

