/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.networking.packet.instrument.util;

import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.client.gui.screen.instrument.InstrumentScreenRegistry;
import com.cstav.genshinstrument.event.InstrumentOpenStateChangedEvent;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.OpenInstrumentPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CHeldNoteSoundPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.S2CNoteSoundPacket;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.util.ServerUtil;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@OnlyIn(value=Dist.CLIENT)
public class ClientDistExec {
    public static final Map<String, BiConsumer<? extends IModPacket, IPayloadContext>> PACKET_SWITCH = Map.ofEntries(ServerUtil.switchEntry(ClientDistExec::handle, S2CNoteSoundPacket.class), ServerUtil.switchEntry(ClientDistExec::handle, S2CHeldNoteSoundPacket.class), ServerUtil.switchEntry(ClientDistExec::handle, OpenInstrumentPacket.class), ServerUtil.switchEntry(ClientDistExec::handle, NotifyInstrumentOpenPacket.class));

    private static void handle(S2CNoteSoundPacket packet, IPayloadContext context) {
        ((NoteSound)packet.sound).playFromServer(packet.initiatorID, packet.meta);
    }

    private static void handle(S2CHeldNoteSoundPacket packet, IPayloadContext context) {
        ((HeldNoteSound)packet.sound).playFromServer(packet.initiatorID, packet.oInitiatorID, packet.meta, packet.phase);
    }

    public static void handle(OpenInstrumentPacket packet, IPayloadContext context) {
        InstrumentScreenRegistry.setScreenByID(packet.instrumentType);
    }

    public static void handle(NotifyInstrumentOpenPacket packet, IPayloadContext context) {
        Player player = Minecraft.getInstance().level.getPlayerByUUID(packet.playerUUID);
        if (player == null) {
            return;
        }
        if (packet.isOpen) {
            if (packet.pos.isPresent()) {
                InstrumentOpenProvider.setOpen(player, packet.pos.get());
            } else {
                InstrumentOpenProvider.setOpen(player, packet.hand.get());
            }
        } else {
            InstrumentOpenProvider.setClosed(player);
        }
        NeoForge.EVENT_BUS.post((Event)new InstrumentOpenStateChangedEvent(packet.isOpen, player, packet.pos, packet.hand));
    }
}

