/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import com.cstav.genshinstrument.event.HeldNoteSoundPlayedEvent;
import com.cstav.genshinstrument.networking.packet.instrument.NoteSoundMetadata;
import com.cstav.genshinstrument.networking.packet.instrument.util.HeldSoundPhase;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSoundInstance;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import com.cstav.genshinstrument.sound.registrar.HeldNoteSoundRegistrar;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public record HeldNoteSound(ResourceLocation baseSoundLocation, int index, NoteSound attack, NoteSound hold, @Nullable NoteSound release, float holdDuration, float holdDelay, float chainedHoldDelay, float decay, float releaseFadeOut, float fullHoldFadeoutTime) {
    public NoteSound getSound(Phase phase) {
        return switch (phase.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> this.hold;
            case 0 -> this.attack;
            case 2 -> this.release;
        };
    }

    public static NoteSound[] getSounds(HeldNoteSound[] sounds, Phase phase) {
        return (NoteSound[])Arrays.stream(sounds).map(sound -> sound.getSound(phase)).toArray(NoteSound[]::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startPlaying(int notePitch, float volume, Entity initiator, BlockPos pos, InitiatorID initiatorId, ResourceLocation instrumentId) {
        new HeldNoteSoundInstance(this, Phase.ATTACK, notePitch, volume, initiator, pos, initiatorId, instrumentId).queueAndAddInstance();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startPlaying(int notePitch, float volume, Entity initiator, InitiatorID initiatorId, ResourceLocation instrumentId) {
        this.startPlaying(notePitch, volume, initiator, null, initiatorId, instrumentId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startPlaying(int notePitch, float volume, Entity initiator, ResourceLocation instrumentId) {
        this.startPlaying(notePitch, volume, initiator, InitiatorID.fromEntity(initiator), instrumentId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startPlaying(int notePitch, float volume, BlockPos pos, InitiatorID initiatorId, ResourceLocation instrumentId) {
        this.startPlaying(notePitch, volume, null, pos, initiatorId, instrumentId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startPlaying(int notePitch, float volume, ResourceLocation instrumentId) {
        this.startPlaying(notePitch, volume, (Entity)Minecraft.getInstance().player, instrumentId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playFromServer(Optional<Integer> initiatorId, Optional<InitiatorID> oInitiatorId, NoteSoundMetadata meta, HeldSoundPhase phase) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        Level level = localPlayer.level();
        InitiatorID _initiatorID = InitiatorID.getEither(initiatorId, oInitiatorId);
        if (initiatorId.isPresent()) {
            Entity initiator = level.getEntity(initiatorId.get().intValue());
            NeoForge.EVENT_BUS.post((Event)new HeldNoteSoundPlayedEvent(initiator, this, meta, phase, _initiatorID));
            if (localPlayer.equals((Object)initiator)) {
                return;
            }
        }
        NeoForge.EVENT_BUS.post((Event)new HeldNoteSoundPlayedEvent(level, this, meta, phase, _initiatorID));
        switch (phase) {
            case ATTACK: {
                this.attackFromServer(_initiatorID, meta);
                break;
            }
            case RELEASE: {
                this.releaseFromServer(_initiatorID, meta);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void attackFromServer(InitiatorID initiatorID, NoteSoundMetadata meta) {
        if (initiatorID.type().equals("entity")) {
            this.startPlaying(meta.pitch(), (float)meta.volume() / 100.0f, Minecraft.getInstance().level.getEntity(Integer.parseInt(initiatorID.identifier())), meta.instrumentId());
        } else {
            this.startPlaying(meta.pitch(), (float)meta.volume() / 100.0f, meta.pos(), initiatorID, meta.instrumentId());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void releaseFromServer(InitiatorID initiatorID, NoteSoundMetadata meta) {
        HeldNoteSounds.release(initiatorID, this, meta.pitch());
    }

    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.baseSoundLocation);
        buf.writeInt(this.index);
    }

    public static HeldNoteSound readFromNetwork(FriendlyByteBuf buf) {
        return HeldNoteSoundRegistrar.getSounds(buf.readResourceLocation())[buf.readInt()];
    }

    public static enum Phase {
        ATTACK,
        HOLD,
        RELEASE;

    }
}

