/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import com.cstav.genshinstrument.client.util.ClientUtil;
import com.cstav.genshinstrument.sound.NoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSound;
import com.cstav.genshinstrument.sound.held.HeldNoteSounds;
import com.cstav.genshinstrument.sound.held.InitiatorID;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class HeldNoteSoundInstance
extends AbstractTickableSoundInstance {
    public final HeldNoteSound heldSoundContainer;
    public final HeldNoteSound.Phase phase;
    public final ResourceLocation instrumentId;
    public final Optional<Entity> initiator;
    public final InitiatorID initiatorId;
    public final Optional<BlockPos> soundOrigin;
    public final int notePitch;
    private boolean released;
    protected int timeAlive = 0;
    protected int overallTimeAlive;
    protected boolean chainedHolding = false;

    protected HeldNoteSoundInstance(HeldNoteSound heldSoundContainer, HeldNoteSound.Phase phase, int notePitch, float volume, @Nullable Entity initiator, @Nullable BlockPos soundOrigin, InitiatorID initiatorId, ResourceLocation instrumentId, int timeAlive, boolean released) {
        super(heldSoundContainer.getSound(phase).getByPreference(HeldNoteSoundInstance.distFromSourceSqr(soundOrigin, initiator)), NoteSound.INSTRUMENT_SOUND_SOURCE, SoundInstance.createUnseededRandom());
        this.initiatorId = initiatorId;
        this.instrumentId = instrumentId;
        this.heldSoundContainer = heldSoundContainer;
        this.phase = phase;
        this.overallTimeAlive = timeAlive;
        this.initiator = Optional.ofNullable(initiator);
        this.soundOrigin = Optional.ofNullable(soundOrigin);
        this.volume = volume;
        this.notePitch = notePitch;
        this.pitch = NoteSound.getPitchByNoteOffset(notePitch);
        this.released = released;
        if (this.distFromSourceSqr() < Mth.square((double)5.5)) {
            this.attenuation = SoundInstance.Attenuation.NONE;
            this.relative = true;
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        } else {
            this.attenuation = SoundInstance.Attenuation.LINEAR;
            this.relative = false;
            this.soundOrigin.ifPresentOrElse(loc -> {
                this.x = loc.getX();
                this.y = loc.getY();
                this.z = loc.getZ();
            }, this::toInitiatorPos);
        }
    }

    public HeldNoteSoundInstance(HeldNoteSound heldSoundContainer, HeldNoteSound.Phase phase, int notePitch, float volume, @Nullable Entity initiator, @Nullable BlockPos soundOrigin, InitiatorID initiatorId, ResourceLocation instrumentId) {
        this(heldSoundContainer, phase, notePitch, volume, initiator, soundOrigin, initiatorId, instrumentId, 0, false);
    }

    public void queueAndAddInstance() {
        Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)this);
        ClientUtil.stopMusicIfClose(this.soundOrigin.orElseGet(this.initiator.map(Entity::blockPosition)::get));
        this.addSoundInstance();
    }

    public void addSoundInstance() {
        HeldNoteSounds.put(this.initiatorId, this.heldSoundContainer, this.notePitch, this);
    }

    protected void removeSoundInstance() {
        HeldNoteSounds.release(this.initiatorId, this.heldSoundContainer, this.notePitch, this);
    }

    public void setReleased() {
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.phase == HeldNoteSound.Phase.HOLD && this.heldSoundContainer.release() != null) {
            Vec3 pos = this.getSourcePos();
            this.heldSoundContainer.release().playLocally(this.pitch, this.volume, new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
        }
    }

    public boolean isReleased() {
        return this.released;
    }

    protected static double distFromSourceSqr(@Nullable BlockPos soundOrigin, @Nullable Entity initiator) {
        return Minecraft.getInstance().player.position().distanceToSqr(HeldNoteSoundInstance.getSourcePos(soundOrigin, initiator));
    }

    public double distFromSourceSqr() {
        return Minecraft.getInstance().player.position().distanceToSqr(this.getSourcePos());
    }

    protected static Vec3 getSourcePos(@Nullable BlockPos soundOrigin, @Nullable Entity initiator) {
        return soundOrigin == null ? initiator.position() : soundOrigin.getCenter();
    }

    protected Vec3 getSourcePos() {
        return HeldNoteSoundInstance.getSourcePos(this.soundOrigin.orElse(null), this.initiator.orElse(null));
    }

    public void tick() {
        this.toInitiatorPos();
        this.handleChainHolding();
        if (this.released) {
            float fadeOutMultiplier = 1.0f;
            float fhft = this.heldSoundContainer.fullHoldFadeoutTime() * 20.0f;
            if (this.phase == HeldNoteSound.Phase.HOLD && fhft != 0.0f && (float)this.overallTimeAlive < fhft) {
                fadeOutMultiplier = 1.0f / ((float)(this.overallTimeAlive + 1) / fhft);
            }
            this.volume -= this.heldSoundContainer.releaseFadeOut() * fadeOutMultiplier;
            if (this.volume <= 0.0f) {
                this.stopHeld();
            }
        }
        ++this.timeAlive;
        ++this.overallTimeAlive;
    }

    protected void handleChainHolding() {
        if (this.chainedHolding || this.pitch == 0.0f) {
            return;
        }
        switch (this.phase) {
            case ATTACK: {
                if (this.timeAlive != (int)(this.heldSoundContainer.holdDelay() * 20.0f)) break;
                this.queueHoldPhase(false);
                this.chainedHolding = true;
                break;
            }
            case HOLD: {
                if (!((float)this.timeAlive * this.pitch >= (float)((int)((this.heldSoundContainer.holdDuration() + this.heldSoundContainer.chainedHoldDelay()) * 20.0f)))) break;
                this.queueHoldPhase(this.heldSoundContainer.decay() > 0.0f);
                this.chainedHolding = true;
                this.removeSoundInstance();
            }
        }
    }

    protected void queueHoldPhase(boolean decreaseVol) {
        if (this.volume <= 0.2f) {
            return;
        }
        new HeldNoteSoundInstance(this.heldSoundContainer, HeldNoteSound.Phase.HOLD, this.notePitch, this.volume - (decreaseVol ? this.heldSoundContainer.decay() : 0.0f), this.initiator.orElse(null), this.soundOrigin.orElse(null), this.initiatorId, this.instrumentId, this.overallTimeAlive, this.released).queueAndAddInstance();
    }

    protected void toInitiatorPos() {
        if (this.relative) {
            return;
        }
        if (this.soundOrigin.isPresent() || this.initiator.isEmpty()) {
            return;
        }
        if (this.released) {
            return;
        }
        this.x = this.initiator.get().getX();
        this.y = this.initiator.get().getY();
        this.z = this.initiator.get().getZ();
    }

    public float getVolume() {
        return this.volume;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void stopHeld() {
        this.stop();
        this.removeSoundInstance();
    }
}

