/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.sound.held;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public record InitiatorID(String type, String identifier) {
    public static final int MAX_UTF_LEN = 65;

    public InitiatorID {
        if (type.length() + identifier.length() > 64) {
            throw new IllegalArgumentException("Initiator type and ID must not exceed length 65");
        }
    }

    public InitiatorID(String id) {
        this(InitiatorID.decompose(id));
    }

    private InitiatorID(String[] decomposed) {
        this(decomposed[0], decomposed[1]);
    }

    private static String[] decompose(String id) {
        String[] result = id.split(":");
        assert (result.length == 2) : "ID must be in the format of type:identifier - received " + id;
        return result;
    }

    public static InitiatorID getEither(Optional<Integer> initiatorId, Optional<InitiatorID> oInitiatorId) {
        return oInitiatorId.orElseGet(() -> InitiatorID.assertIIDPresent(initiatorId.map(arg_0 -> ((ClientLevel)Minecraft.getInstance().level).getEntity(arg_0)).map(InitiatorID::fromEntity)));
    }

    private static InitiatorID assertIIDPresent(Optional<InitiatorID> initiatorID) {
        assert (initiatorID.isPresent()) : "Must either have an entity initiator or an initiator ID!";
        return initiatorID.get();
    }

    public static InitiatorID fromObj(@NotNull Object initiator) {
        InitiatorID initiatorID;
        if (initiator instanceof Entity) {
            Entity entity = (Entity)initiator;
            initiatorID = InitiatorID.fromEntity(entity);
        } else {
            initiatorID = new InitiatorID("other", initiator.toString());
        }
        return initiatorID;
    }

    public static InitiatorID fromEntity(@NotNull Entity entity) {
        return new InitiatorID("entity", String.valueOf(entity.getId()));
    }

    public static InitiatorID readFromNetwork(FriendlyByteBuf buf) {
        return new InitiatorID(buf.readUtf(), buf.readUtf());
    }

    public void writeToNetwork(FriendlyByteBuf buf) {
        buf.writeUtf(this.type);
        buf.writeUtf(this.identifier);
    }

    @Override
    public String toString() {
        return String.format("%s:%s", this.type, this.identifier);
    }
}

