/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.util;

import com.cstav.genshinstrument.client.config.ModClientConfigs;
import com.cstav.genshinstrument.util.CommonUtil;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public abstract class LabelUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String[] DO_RE_MI = new String[]{"do", "re", "mi", "fa", "so", "la", "ti"};
    public static final char[] ABC = new char[]{'C', 'D', 'E', 'F', 'G', 'A', 'B'};
    private static final HashMap<Character, String> ABC_TO_DO_RE_MI = new HashMap();
    public static final Map<String, String[]> NOTE_SCALES;
    public static final int NOTES_PER_SCALE;

    private static String[] strArr(String ... arr) {
        return arr;
    }

    public static String getNoteName(int pitch, String[] noteLayout, int offset) {
        String baseNote = noteLayout[CommonUtil.wrapAround(offset, noteLayout.length)];
        String[] scale = NOTE_SCALES.get(baseNote);
        return scale[CommonUtil.doublyPyWrap(pitch, scale.length)];
    }

    public static String formatNoteName(String noteName, boolean omitIfAccurate) {
        if (noteName.isEmpty()) {
            return "";
        }
        Object result = String.valueOf(noteName.charAt(0));
        if (!omitIfAccurate || !((Boolean)ModClientConfigs.ACCURATE_NOTES.get()).booleanValue()) {
            result = (String)result + noteName.substring(1).replaceAll("##", "\u00d7").replaceAll("#", "\u266f").replaceAll("b", "\u266d");
        }
        return result;
    }

    public static Component toDoReMi(String noteName) {
        if (noteName.isEmpty()) {
            LOGGER.warn("Cannot convert empty note to Do Re Mi!");
            return Component.empty();
        }
        return Component.translatable((String)("genshinstrument.label." + ABC_TO_DO_RE_MI.get(Character.valueOf(noteName.charAt(0))))).append(noteName.substring(1));
    }

    static {
        for (int i = 0; i < ABC.length; ++i) {
            ABC_TO_DO_RE_MI.put(Character.valueOf(ABC[i]), DO_RE_MI[i]);
        }
        NOTE_SCALES = Map.ofEntries(Map.entry("Cb", LabelUtil.strArr("Cb", "Dbb", "Db", "Ebb", "Eb", "Fb", "Gbb", "Gb", "Abb", "Ab", "Bbb", "Bb")), Map.entry("C", LabelUtil.strArr("C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B")), Map.entry("C#", LabelUtil.strArr("C#", "D", "D#", "E", "E#", "F#", "G", "G#", "A", "A#", "B", "B#")), Map.entry("Db", LabelUtil.strArr("Db", "Ebb", "Eb", "Fb", "F", "Gb", "Abb", "Ab", "Bbb", "Bb", "Cb", "C")), Map.entry("D", LabelUtil.strArr("D", "Eb", "E", "F", "F#", "G", "Ab", "A", "Bb", "B", "C", "C#")), Map.entry("D#", LabelUtil.strArr("D#", "E", "E#", "F#", "F##", "G#", "A", "A#", "B", "B#", "C#", "C##")), Map.entry("Eb", LabelUtil.strArr("Eb", "Fb", "F", "Gb", "G", "Ab", "Bbb", "Bb", "Cb", "C", "Db", "D")), Map.entry("E", LabelUtil.strArr("E", "F", "F#", "G", "G#", "A", "Bb", "B", "C", "C#", "D", "D#")), Map.entry("E#", LabelUtil.strArr("E#", "F#", "F##", "G#", "G##", "A#", "B", "B#", "C#", "C##", "D#", "D##")), Map.entry("Fb", LabelUtil.strArr("Fb", "Gbb", "Gb", "Abb", "Ab", "Bbb", "Cbb", "Cb", "Dbb", "Db", "Ebb", "Eb")), Map.entry("F", LabelUtil.strArr("F", "Gb", "G", "Ab", "A", "Bb", "Cb", "C", "Db", "D", "Eb", "E")), Map.entry("F#", LabelUtil.strArr("F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "E#")), Map.entry("Gb", LabelUtil.strArr("Gb", "Abb", "Ab", "Bbb", "Bb", "Cb", "Dbb", "Db", "Ebb", "Eb", "Fb", "F")), Map.entry("G", LabelUtil.strArr("G", "Ab", "A", "Bb", "B", "C", "Db", "D", "Eb", "E", "F", "F#")), Map.entry("G#", LabelUtil.strArr("G#", "A", "A#", "B", "B#", "C#", "D", "D#", "E", "E#", "F#", "F##")), Map.entry("Ab", LabelUtil.strArr("Ab", "Bbb", "Bb", "Cb", "C", "Db", "Ebb", "Eb", "Fb", "F", "Gb", "G")), Map.entry("A", LabelUtil.strArr("A", "Bb", "B", "C", "C#", "D", "Eb", "E", "F", "F#", "G", "G#")), Map.entry("A#", LabelUtil.strArr("A#", "B", "B#", "C#", "C##", "D#", "E", "E#", "F#", "F##", "G#", "G##")), Map.entry("Bb", LabelUtil.strArr("Bb", "Cb", "C", "Db", "D", "Eb", "Fb", "F", "Gb", "G", "Ab", "A")), Map.entry("B", LabelUtil.strArr("B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#")), Map.entry("B#", LabelUtil.strArr("B#", "C#", "C##", "D#", "D##", "E#", "F#", "F##", "G#", "G##", "A#", "A##")), Map.entry("Am", LabelUtil.strArr("Am", "A#m", "Bm", "Cm", "C#m", "Dm", "D#m", "Em", "Fm", "F#m", "Gm", "G#m")), Map.entry("Dm", LabelUtil.strArr("Dm", "D#m", "Em", "Fm", "F#m", "Gm", "G#m", "Am", "A#m", "Bm", "Cm", "C#m")), Map.entry("Em", LabelUtil.strArr("Em", "Fm", "F#m", "Gm", "G#m", "Am", "A#m", "Bm", "Cm", "C#m", "Dm", "D#m")), Map.entry("G7", LabelUtil.strArr("G7", "Ab7", "A7", "Bb7", "B7", "C7", "Db7", "D7", "Eb7", "E7", "F7", "F#7")));
        NOTES_PER_SCALE = NOTE_SCALES.get("C").length;
    }
}

