/*
 * Decompiled with CFR 0.152.
 */
package com.cstav.genshinstrument.util;

import com.cstav.genshinstrument.attachment.instrumentopen.InstrumentOpenProvider;
import com.cstav.genshinstrument.networking.GIPacketHandler;
import com.cstav.genshinstrument.networking.IModPacket;
import com.cstav.genshinstrument.networking.packet.instrument.s2c.NotifyInstrumentOpenPacket;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class ServerUtil {
    public static void registerC2SPackets(List<Class<IModPacket>> packetTypes, PayloadRegistrar payloadRegistrar) {
        for (Class<IModPacket> packetClass : packetTypes) {
            payloadRegistrar.playToServer(IModPacket.type(packetClass), IModPacket.codec(packetClass), (packet, context) -> context.enqueueWork(() -> packet.handleServer(context)));
        }
    }

    public static void registerS2CPackets(List<Class<IModPacket>> packetTypes, Supplier<Map<String, BiConsumer<? extends IModPacket, IPayloadContext>>> packetSwitchSupplier, PayloadRegistrar payloadRegistrar) {
        for (Class<IModPacket> packetClass : packetTypes) {
            payloadRegistrar.playToClient(IModPacket.type(packetClass), IModPacket.codec(packetClass), (packet, context) -> ServerUtil.executeClientPacketHandler(packet, context, packetSwitchSupplier));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void executeClientPacketHandler(IModPacket packet, IPayloadContext context, Supplier<Map<String, BiConsumer<? extends IModPacket, IPayloadContext>>> packetSwitchSupplier) {
        BiConsumer<? extends IModPacket, IPayloadContext> packetHandler = packetSwitchSupplier.get().get(packet.type().id().getPath());
        packetHandler.accept(packet, context);
    }

    public static <T extends IModPacket> Map.Entry<String, BiConsumer<T, IPayloadContext>> switchEntry(BiConsumer<T, IPayloadContext> handler, Class<T> packetType) {
        return Map.entry(IModPacket.path(packetType), handler);
    }

    public static void notifyOpenStateToPlayers(ServerPlayer target) {
        Level level = target.level();
        level.players().forEach(player -> {
            if (player.equals((Object)target)) {
                return;
            }
            if (InstrumentOpenProvider.isOpen(player)) {
                ServerUtil.notifyOpenStateToPlayer(player, target);
            }
        });
    }

    public static void notifyOpenStateToPlayer(Player player, ServerPlayer target) {
        if (!InstrumentOpenProvider.isOpen(player)) {
            return;
        }
        NotifyInstrumentOpenPacket packet = InstrumentOpenProvider.isItem(player) ? new NotifyInstrumentOpenPacket(player.getUUID(), InstrumentOpenProvider.getHand(player)) : new NotifyInstrumentOpenPacket(player.getUUID(), InstrumentOpenProvider.getBlockPos(player));
        GIPacketHandler.sendToClient(packet, target);
    }
}

