/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.jomcraft.defaultsettings.DefaultSettings;
import net.jomcraft.jcplugin.FileUtilNoMC;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class ConfigArguments
implements ArgumentType<String> {
    private static List<String> ARGUMENTS = Arrays.asList("fml.toml", "forge-client.toml");

    public static ConfigArguments configArguments() {
        return new ConfigArguments();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return this.readQuotedString(reader);
    }

    public String readQuotedString(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            return "";
        }
        char next = reader.getString().charAt(reader.getCursor());
        if (!StringReader.isQuotedStringStart((char)next)) {
            int start = reader.getCursor();
            while (reader.canRead()) {
                reader.skip();
            }
            return reader.getString().substring(start, reader.getCursor());
        }
        reader.skip();
        return reader.readStringUntil(next);
    }

    public static String getString(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        try {
            ArrayList<String> filtered = new ArrayList<String>();
            ArrayList prevList = FileUtilNoMC.listConfigFiles();
            for (int i = 0; i < prevList.size(); ++i) {
                Object name = (String)prevList.get(i);
                if (((String)name).contains(" ")) {
                    name = "\"" + (String)name + "\"";
                }
                filtered.add((String)name);
            }
            ARGUMENTS = filtered;
        }
        catch (IOException e) {
            DefaultSettings.log.error((Object)e);
        }
        return SharedSuggestionProvider.suggest(ARGUMENTS, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return ARGUMENTS;
    }

    public static class Info
    implements ArgumentTypeInfo<ConfigArguments, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new Template();
        }

        public void serializeToJson(Template template, JsonObject json) {
        }

        public Template unpack(ConfigArguments argument) {
            return new Template();
        }

        public class Template
        implements ArgumentTypeInfo.Template<ConfigArguments> {
            Template() {
            }

            public ConfigArguments instantiate(CommandBuildContext p_223435_) {
                return new ConfigArguments();
            }

            public ArgumentTypeInfo<ConfigArguments, ?> type() {
                return Info.this;
            }
        }
    }
}

