/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.config;

import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.config.option.GraphicsState;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.sounds.SoundSource;

public class Config {
    private int frameRateTarget;
    private boolean enableVsync;
    private final Map<String, Float> volumeMultipliers;
    private GraphicsState graphicsState;
    private boolean showToasts;
    private boolean runGarbageCollector;
    protected transient PowerState state;
    public static final Config ACTIVE = new Config(-1, false, new HashMap<String, Float>(), GraphicsState.DEFAULT, true, false);

    public Config(int frameRateTarget, boolean enableVsync, Map<String, Float> volumeMultipliers, GraphicsState graphicsState, boolean showToasts, boolean runGarbageCollector) {
        this.frameRateTarget = frameRateTarget;
        this.enableVsync = enableVsync;
        this.volumeMultipliers = new HashMap<String, Float>(volumeMultipliers);
        this.graphicsState = graphicsState;
        this.showToasts = showToasts;
        this.runGarbageCollector = runGarbageCollector;
    }

    public int frameRateTarget() {
        if (this.frameRateTarget != -1) {
            return this.frameRateTarget;
        }
        return 260;
    }

    public void setFrameRateTarget(int value) {
        this.frameRateTarget = value == 260 ? -1 : value;
    }

    public boolean enableVsync() {
        return this.enableVsync;
    }

    public void setEnableVsync(boolean value) {
        this.enableVsync = value;
    }

    public float volumeMultiplier(SoundSource source) {
        if (this.rawVolumeMultiplier(SoundSource.MASTER) == 0.0f) {
            return 0.0f;
        }
        return this.rawVolumeMultiplier(source);
    }

    public float rawVolumeMultiplier(SoundSource source) {
        String key = Config.soundSourceName(source);
        return this.volumeMultipliers.getOrDefault(key, Float.valueOf(1.0f)).floatValue();
    }

    public void setVolumeMultiplier(SoundSource source, float value) {
        String key = Config.soundSourceName(source);
        Config defaultConfig = DynamicFPSConfig.DEFAULTS.get(this.state);
        if (value != 1.0f || defaultConfig.rawVolumeMultiplier(source) != 1.0f) {
            this.volumeMultipliers.put(key, Float.valueOf(value));
        } else {
            this.volumeMultipliers.remove(key);
        }
    }

    private static String soundSourceName(SoundSource source) {
        return source.getName().toLowerCase(Locale.ROOT);
    }

    public GraphicsState graphicsState() {
        return this.graphicsState;
    }

    public void setGraphicsState(GraphicsState value) {
        this.graphicsState = value;
    }

    public boolean showToasts() {
        return this.showToasts;
    }

    public void setShowToasts(boolean value) {
        this.showToasts = value;
    }

    public boolean runGarbageCollector() {
        return this.runGarbageCollector;
    }

    public void setRunGarbageCollector(boolean value) {
        this.runGarbageCollector = value;
    }
}

