/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.api.events.server;

import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Pair;
import dev.kosmx.playerAnim.core.util.UUIDMap;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public abstract class ServerEmoteAPI {
    protected static ServerEmoteAPI INSTANCE;

    public static void setPlayerPlayingEmote(UUID player, @Nullable KeyframeAnimation emote) {
        INSTANCE.setPlayerPlayingEmoteImpl(player, emote, false);
    }

    public static void forcePlayEmote(UUID player, @Nullable KeyframeAnimation emote) {
        INSTANCE.setPlayerPlayingEmoteImpl(player, emote, true);
    }

    public static void playEmote(UUID player, @Nullable KeyframeAnimation emote, boolean forced) {
        INSTANCE.setPlayerPlayingEmoteImpl(player, emote, forced);
    }

    @Nullable
    public static Pair<KeyframeAnimation, Integer> getPlayedEmote(UUID player) {
        return INSTANCE.getPlayedEmoteImpl(player);
    }

    public static boolean isForcedEmote(UUID player) {
        return INSTANCE.isForcedEmoteImpl(player);
    }

    public static HashMap<UUID, KeyframeAnimation> getLoadedEmotes() {
        return INSTANCE.getLoadedEmotesImpl();
    }

    public static UUIDMap<KeyframeAnimation> getPublicEmotes() {
        return INSTANCE.getPublicEmotesImpl();
    }

    public static UUIDMap<KeyframeAnimation> getHiddenEmotes() {
        return INSTANCE.getHiddenEmotesImpl();
    }

    public static List<KeyframeAnimation> deserializeEmote(InputStream inputStream, @Nullable String quarkName, String format) {
        return INSTANCE.deserializeEmoteImpl(inputStream, quarkName, format);
    }

    @Nullable
    public static KeyframeAnimation getEmote(UUID emoteID) {
        return INSTANCE.getEmoteImpl(emoteID);
    }

    protected abstract void setPlayerPlayingEmoteImpl(UUID var1, @Nullable KeyframeAnimation var2, boolean var3);

    protected abstract Pair<KeyframeAnimation, Integer> getPlayedEmoteImpl(UUID var1);

    protected abstract boolean isForcedEmoteImpl(UUID var1);

    protected abstract HashMap<UUID, KeyframeAnimation> getLoadedEmotesImpl();

    protected abstract UUIDMap<KeyframeAnimation> getPublicEmotesImpl();

    protected abstract UUIDMap<KeyframeAnimation> getHiddenEmotesImpl();

    protected abstract List<KeyframeAnimation> deserializeEmoteImpl(InputStream var1, @Nullable String var2, String var3);

    protected abstract KeyframeAnimation getEmoteImpl(UUID var1);
}

