/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import net.minecraft.client.color.item.ItemColors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.gear.PartTypes;

public final class ColorHandlers {
    private ColorHandlers() {
    }

    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        if (itemColors == null) {
            SilentGear.LOGGER.error("ItemColors is null?", (Throwable)new IllegalStateException("wat?"));
            return;
        }
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof GearItem).map(item -> (GearItem)item).forEach(item -> event.register(item.getItemColors(), new ItemLike[]{item}));
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof CompoundPartItem).map(item -> (CompoundPartItem)((Object)item)).forEach(item -> event.register(item::getColor, new ItemLike[]{item}));
        SgItems.getItems(item -> item instanceof IColoredMaterialItem).forEach(item -> {
            IColoredMaterialItem coloredMaterialItem = (IColoredMaterialItem)item;
            event.register(coloredMaterialItem::getColor, new ItemLike[]{item});
        });
    }

    public static int getShieldColor(ItemStack stack, int tintIndex) {
        return switch (tintIndex) {
            case 0 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.ROD.get());
            case 1 -> ColorUtils.getBlendedColorForPartInGear(stack, (PartType)PartTypes.MAIN.get());
            default -> -1;
        };
    }
}

