/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.silentchaos512.gear.gear.GearJsonException;
import net.silentchaos512.gear.network.payload.server.DataResourcesPayload;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.NotNull;

public class DataResourceManager<T>
implements ResourceManagerReloadListener,
Iterable<T> {
    private final Codec<T> codec;
    private final JsonExceptionFactory<?> exceptionFactory;
    private final String typeName;
    private final String dataPath;
    private final Marker logMarker;
    private final Logger logger;
    private final Map<ResourceLocation, T> byKey = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<T, ResourceLocation> byValue = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<ResourceLocation, String> packNameByKey = new HashMap<ResourceLocation, String>();
    private final List<T> values = new ArrayList<T>();
    private final Collection<ResourceLocation> errorList = new ArrayList<ResourceLocation>();
    private final Codec<T> byNameCodec;

    public DataResourceManager(Codec<T> codec, JsonExceptionFactory<?> exceptionFactory, String typeName, String dataPath, String logMarkerName, Logger logger) {
        this.codec = codec;
        this.exceptionFactory = exceptionFactory;
        this.typeName = typeName;
        this.dataPath = dataPath;
        this.logMarker = MarkerManager.getMarker((String)logMarkerName);
        this.logger = logger;
        this.byNameCodec = ResourceLocation.CODEC.flatXmap(id -> Optional.ofNullable(this.get((ResourceLocation)id)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown " + this.typeName + " key: " + String.valueOf(id))), component -> Optional.of(this.getKey(component)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown " + this.typeName + ": " + String.valueOf(component))));
    }

    public void validate(T value, JsonObject json) {
    }

    public void validateAll() {
    }

    public void attachExtraData(T value, String packName, JsonObject json) {
    }

    public Codec<T> byNameCodec() {
        return this.byNameCodec;
    }

    @Nullable
    public T get(ResourceLocation key) {
        return this.byKey.get(key);
    }

    public ResourceLocation getKey(T value) {
        return this.byValue.get(value);
    }

    @Nonnull
    public String getPackName(T value) {
        if (this.byValue.containsKey(value)) {
            return this.packNameByKey.get(this.getKey(value));
        }
        return "UNKNOWN PACK";
    }

    public Set<ResourceLocation> keySet() {
        return this.byKey.keySet();
    }

    public Set<Map.Entry<ResourceLocation, T>> entrySet() {
        return this.byKey.entrySet();
    }

    public Map<ResourceLocation, T> copyOfMap() {
        return (Map)Util.make(() -> {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            this.entrySet().forEach(entry -> builder.put((Object)((ResourceLocation)entry.getKey()), entry.getValue()));
            return builder.build();
        });
    }

    public Optional<T> getRandom(RandomSource random) {
        return Util.getRandomSafe(this.values, (RandomSource)random);
    }

    public boolean containsKey(ResourceLocation name) {
        return this.byKey.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Iterator<T> iterator() {
        Map<ResourceLocation, T> map = this.byKey;
        synchronized (map) {
            return this.byKey.values().iterator();
        }
    }

    public Collection<Component> getErrorMessages(ServerPlayer player) {
        if (!this.errorList.isEmpty()) {
            String listStr = this.errorList.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "));
            return ImmutableList.of((Object)Component.literal((String)("[Silent Gear] The following " + this.typeName + "s failed to load, check your log file:")).withStyle(ChatFormatting.RED), (Object)Component.literal((String)listStr));
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResourceManagerReload(ResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Map resources = resourceManager.listResources(this.dataPath, s -> s.toString().endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<Object, Object> map = this.byKey;
        synchronized (map) {
            this.byKey.clear();
            this.packNameByKey.clear();
            this.errorList.clear();
            this.logger.info(this.logMarker, "Reloading {} files", (Object)this.typeName);
            for (ResourceLocation id : resources.keySet()) {
                String path = id.getPath().substring(this.dataPath.length() + 1, id.getPath().length() - ".json".length());
                ResourceLocation name = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)path);
                Optional resourceOptional = resourceManager.getResource(id);
                if (!resourceOptional.isPresent()) continue;
                Resource resource = (Resource)resourceOptional.get();
                String packName = resource.sourcePackId();
                JsonObject json = null;
                try {
                    String string = IOUtils.toString((InputStream)resource.open(), (Charset)StandardCharsets.UTF_8);
                    json = (JsonObject)GsonHelper.fromJson((Gson)gson, (String)string, JsonObject.class);
                }
                catch (IOException ex) {
                    this.logger.error(this.logMarker, "Could not read {}: {}", (Object)this.typeName, (Object)name, (Object)ex);
                    this.errorList.add(name);
                }
                if (json == null) {
                    this.logger.error(this.logMarker, "Could not load {} \"{}\" as it's null or empty", (Object)this.typeName, (Object)name);
                    continue;
                }
                T value2 = this.tryDecode(name, packName, json);
                this.validate(value2, json);
                this.attachExtraData(value2, packName, json);
                this.tryAddObject(name, value2);
                this.packNameByKey.put(name, packName);
            }
        }
        map = this.byValue;
        synchronized (map) {
            this.byValue.clear();
            this.byKey.forEach((? super K key, ? super V value) -> this.byValue.put((T)value, (ResourceLocation)key));
        }
        this.logger.info(this.logMarker, "Decoded {} {}s", (Object)this.byKey.size(), (Object)this.typeName);
        this.validateAll();
    }

    private void tryAddObject(ResourceLocation id, T value) {
        if (this.byKey.containsKey(id)) {
            throw new IllegalArgumentException("Duplicate " + this.typeName + ": " + String.valueOf(id));
        }
        this.byKey.put(id, value);
        this.values.add(value);
    }

    private T tryDecode(ResourceLocation name, String packName, JsonObject json) {
        DataResult result;
        this.logger.info(this.logMarker, "Decoding {} \"{}\" in pack \"{}\"", (Object)this.typeName, (Object)name, (Object)packName);
        try {
            result = this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json);
        }
        catch (Exception ex) {
            this.logger.info(this.logMarker, "Error decoding {} \"{}\" in pack \"{}\"", (Object)this.typeName, (Object)name, (Object)packName);
            throw this.exceptionFactory.create(name, packName, ex);
        }
        if (result.isSuccess()) {
            return (T)((Pair)result.result().get()).getFirst();
        }
        JsonSyntaxException cause = new JsonSyntaxException(((DataResult.Error)result.error().get()).message());
        throw this.exceptionFactory.create(name, packName, (Throwable)cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSyncPacket(DataResourcesPayload<T> data, IPayloadContext ctx) {
        Map<Object, Object> map = this.byKey;
        synchronized (map) {
            this.byKey.clear();
            this.byKey.putAll(data.values());
        }
        map = this.byValue;
        synchronized (map) {
            this.byValue.clear();
            this.values.clear();
            this.byKey.forEach((? super K key, ? super V value) -> {
                this.byValue.put((T)value, (ResourceLocation)key);
                this.values.add(value);
            });
        }
        this.logger.info(this.logMarker, "Received {} {}s from server", (Object)this.byKey.size(), (Object)this.typeName);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @FunctionalInterface
    public static interface JsonExceptionFactory<E extends GearJsonException> {
        public E create(ResourceLocation var1, String var2, Throwable var3);
    }
}

