/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.advancements.criterion.GearPropertyTrigger;
import net.silentchaos512.gear.advancements.criterion.GearRepairedTrigger;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.setup.GearItemSets;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgCriteriaTriggers;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgTags;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.util.NameUtils;

public class ModAdvancementProvider
extends AdvancementProvider {
    public ModAdvancementProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper(), Collections.singletonList(new Advancements()));
    }

    private static class Advancements
    implements AdvancementProvider.AdvancementGenerator {
        private Advancements() {
        }

        public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
            ItemStack rootIcon = new ItemStack((ItemLike)GearItemSets.PICKAXE.gearItem());
            GearData.writeConstructionParts(rootIcon, (Collection<PartInstance>)ImmutableList.of((Object)PartInstance.create(Const.Parts.PICKAXE_HEAD, (CompoundPartItem)GearItemSets.PICKAXE.mainPart(), Const.Materials.CRIMSON_STEEL), (Object)PartInstance.create(Const.Parts.ROD, (CompoundPartItem)((Object)SgItems.ROD.get()), Const.Materials.BLAZE_GOLD), (Object)PartInstance.create(Const.Parts.TIP, (CompoundPartItem)((Object)SgItems.TIP.get()), Const.Materials.AZURE_ELECTRUM), (Object)PartInstance.create(Const.Parts.GRIP, (CompoundPartItem)((Object)SgItems.GRIP.get()), Const.Materials.WOOL_BLACK), (Object)PartInstance.create(Const.Parts.BINDING, (CompoundPartItem)((Object)SgItems.BINDING.get()), Const.Materials.STRING)));
            AdvancementHolder root = Advancement.Builder.advancement().display(rootIcon, Advancements.title("root"), Advancements.description("root"), ResourceLocation.withDefaultNamespace((String)"textures/gui/advancements/backgrounds/adventure.png"), AdvancementType.TASK, false, false, false).addCriterion("get_item", Advancements.getItem(new ItemLike[]{Items.CRAFTING_TABLE})).save(saver, Advancements.id("root"));
            AdvancementHolder overworldPlants = Advancement.Builder.advancement().parent(root).display((ItemLike)CraftingItems.FLAX_FIBER, Advancements.title("overworld_plants"), Advancements.description("overworld_plants"), null, AdvancementType.TASK, true, true, false).addCriterion("flax_seeds", Advancements.getItem(new ItemLike[]{SgItems.FLAX_SEEDS})).addCriterion("flax_fibers", Advancements.getItem(CraftingItems.FLAX_FIBER)).addCriterion("fluffy_seeds", Advancements.getItem(new ItemLike[]{SgItems.FLUFFY_SEEDS})).addCriterion("fluffy_puffs", Advancements.getItem(CraftingItems.FLUFFY_PUFF)).requirements(AdvancementRequirements.Strategy.AND).save(saver, Advancements.id("overworld_plants"));
            AdvancementHolder kachink1 = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.IRON_NUGGET, Advancements.title("kachink1"), Advancements.description("kachink1"), null, AdvancementType.TASK, true, true, false).addCriterion("kachink", ((PlayerTrigger)SgCriteriaTriggers.DAMAGE_FACTOR_CHANGE.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(saver, Advancements.id("kachink1"));
            AdvancementHolder kachink2 = Advancement.Builder.advancement().parent(kachink1).display((ItemLike)CraftingItems.DIAMOND_SHARD, Advancements.title("kachink2"), Advancements.description("kachink2"), null, AdvancementType.TASK, true, true, false).addCriterion("kachink", ((PlayerTrigger)SgCriteriaTriggers.BRITTLE_DAMAGE.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(saver, Advancements.id("kachink2"));
            AdvancementHolder stoneAnvil = Advancements.simpleGetItem(saver, SgBlocks.STONE_ANVIL, root);
            AdvancementHolder crudeKnife = Advancements.simpleGetItem(saver, SgItems.CRUDE_KNIFE, stoneAnvil);
            AdvancementHolder templateBoard = Advancements.simpleGetItem(saver, CraftingItems.TEMPLATE_BOARD, crudeKnife);
            AdvancementHolder blueprintPaper = Advancements.simpleGetItem(saver, CraftingItems.BLUEPRINT_PAPER, root);
            Advancement.Builder builder = Advancement.Builder.advancement().parent(templateBoard).display(SgItems.CRUDE_REPAIR_KIT, Advancements.title("repair_kit"), Advancements.description("repair_kit"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR);
            SgItems.getItems(RepairKitItem.class).forEach(item -> builder.addCriterion(NameUtils.fromItem((ItemLike)item).getPath(), Advancements.getItem(new ItemLike[]{item})));
            AdvancementHolder repairKit = builder.save(saver, Advancements.id("repair_kit"));
            AdvancementHolder crimsonRepairKit = Advancements.simpleGetItem(saver, SgItems.CRIMSON_REPAIR_KIT, repairKit);
            AdvancementHolder azureRepairKit = Advancements.simpleGetItem(saver, SgItems.AZURE_REPAIR_KIT, crimsonRepairKit);
            AdvancementHolder repairFromBroken = Advancement.Builder.advancement().parent(repairKit).display((ItemLike)Items.FLINT, Advancements.title("repair_from_broken"), Advancements.description("repair_from_broken"), null, AdvancementType.TASK, true, true, false).addCriterion("repair", ((GearRepairedTrigger)((Object)SgCriteriaTriggers.GEAR_REPAIRED.get())).createCriterion((CriterionTriggerInstance)new GearRepairedTrigger.Instance(Optional.empty(), MinMaxBounds.Ints.atLeast((int)1), MinMaxBounds.Ints.atLeast((int)1)))).save(saver, Advancements.id("repair_from_broken"));
            AdvancementHolder blueprintBook = Advancements.simpleGetItem(saver, SgItems.BLUEPRINT_BOOK, blueprintPaper);
            AdvancementHolder tipUpgrade = Advancements.simpleGetItem(saver, SgItems.TIP, ((CompoundPartItem)((Object)SgItems.TIP.get())).create(MaterialInstance.of(Const.Materials.EXAMPLE)), templateBoard, "tip_upgrade");
            AdvancementHolder armor = Advancement.Builder.advancement().parent(blueprintPaper).display((ItemLike)GearItemSets.HELMET.gearItem(), Advancements.title("armor"), Advancements.description("armor"), null, AdvancementType.TASK, true, true, false).addCriterion("helmet", Advancements.getItem(GearItemSets.HELMET.gearItem())).addCriterion("chestplate", Advancements.getItem(GearItemSets.CHESTPLATE.gearItem())).addCriterion("leggings", Advancements.getItem(GearItemSets.LEGGINGS.gearItem())).addCriterion("boots", Advancements.getItem(GearItemSets.BOOTS.gearItem())).requirements(AdvancementRequirements.Strategy.OR).save(saver, Advancements.id("armor"));
            AdvancementHolder bow = Advancement.Builder.advancement().parent(blueprintPaper).display((ItemLike)GearItemSets.BOW.gearItem(), Advancements.title("bow"), Advancements.description("bow"), null, AdvancementType.TASK, true, true, false).addCriterion("get_item", Advancements.getItem(GearItemSets.BOW.gearItem())).save(saver, Advancements.id("bow"));
            AdvancementHolder standardTools = Advancement.Builder.advancement().parent(blueprintPaper).display((ItemLike)GearItemSets.PICKAXE.gearItem(), Advancements.title("standard_tools"), Advancements.description("standard_tools"), null, AdvancementType.TASK, true, true, false).addCriterion("pickaxe", Advancements.getItem(GearItemSets.PICKAXE.gearItem())).addCriterion("shovel", Advancements.getItem(GearItemSets.SHOVEL.gearItem())).addCriterion("axe", Advancements.getItem(GearItemSets.AXE.gearItem())).requirements(AdvancementRequirements.Strategy.AND).save(saver, Advancements.id("standard_tools"));
            AdvancementHolder swords = Advancement.Builder.advancement().parent(blueprintPaper).display((ItemLike)GearItemSets.SWORD.gearItem(), Advancements.title("swords"), Advancements.description("swords"), null, AdvancementType.TASK, true, true, false).addCriterion("sword", Advancements.getItem(GearItemSets.SWORD.gearItem())).addCriterion("katana", Advancements.getItem(GearItemSets.KATANA.gearItem())).addCriterion("machete", Advancements.getItem(GearItemSets.MACHETE.gearItem())).requirements(AdvancementRequirements.Strategy.AND).save(saver, Advancements.id("swords"));
            AdvancementHolder bigJobTools = Advancement.Builder.advancement().parent(standardTools).display((ItemLike)GearItemSets.HAMMER.gearItem(), Advancements.title("big_job_tools"), Advancements.description("big_job_tools"), null, AdvancementType.TASK, true, true, false).addCriterion("hammer", Advancements.getItem(GearItemSets.HAMMER.gearItem())).addCriterion("excavator", Advancements.getItem(GearItemSets.EXCAVATOR.gearItem())).addCriterion("lumber_axe", Advancements.getItem(GearItemSets.SAW.gearItem())).requirements(AdvancementRequirements.Strategy.AND).save(saver, Advancements.id("big_job_tools"));
            AdvancementHolder crossbow = Advancements.simpleGetItem(saver, GearItemSets.CROSSBOW.gearItem(), bow);
            AdvancementHolder mattock = Advancements.simpleGetItem(saver, GearItemSets.MATTOCK.gearItem(), standardTools);
            AdvancementHolder sickle = Advancements.simpleGetItem(saver, GearItemSets.SICKLE.gearItem(), mattock);
            AdvancementHolder nether = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.OBSIDIAN, Advancements.title("nether"), Advancements.description("nether"), null, AdvancementType.TASK, false, false, false).addCriterion("entered_nether", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo((ResourceKey)Level.NETHER)).save(saver, Advancements.id("nether"));
            AdvancementHolder netherPlants = Advancement.Builder.advancement().parent(nether).display(SgItems.NETHER_BANANA, Advancements.title("nether_plants"), Advancements.description("nether_plants"), null, AdvancementType.TASK, true, true, false).addCriterion("banana", Advancements.getItem(new ItemLike[]{SgItems.NETHER_BANANA})).addCriterion("sapling", Advancements.getItem(new ItemLike[]{SgBlocks.NETHERWOOD_SAPLING})).requirements(AdvancementRequirements.Strategy.AND).save(saver, Advancements.id("nether_plants"));
            AdvancementHolder blazeGold = Advancements.simpleGetItem(saver, CraftingItems.BLAZE_GOLD_INGOT, nether, "blaze_gold");
            AdvancementHolder crimsonIron = Advancement.Builder.advancement().parent(nether).display((ItemLike)CraftingItems.CRIMSON_IRON_INGOT, Advancements.title("crimson_iron"), Advancements.description("crimson_iron"), null, AdvancementType.TASK, true, true, false).addCriterion("get_ore", Advancements.getItem(CraftingItems.RAW_CRIMSON_IRON)).addCriterion("get_ingot", Advancements.getItem(CraftingItems.CRIMSON_IRON_INGOT)).save(saver, Advancements.id("crimson_iron"));
            AdvancementHolder materialGrader = Advancement.Builder.advancement().parent(blazeGold).display(SgBlocks.MATERIAL_GRADER, Advancements.title("material_grader"), Advancements.description("material_grader"), null, AdvancementType.TASK, true, true, false).addCriterion("get_grader", Advancements.getItem(new ItemLike[]{SgBlocks.MATERIAL_GRADER})).addCriterion("get_catalyst", Advancements.getItem(SgTags.Items.GRADER_CATALYSTS_TIER_1)).save(saver, Advancements.id("material_grader"));
            AdvancementHolder crimsonSteel = Advancements.simpleGetItem(saver, CraftingItems.CRIMSON_STEEL_INGOT, crimsonIron, "crimson_steel");
            AdvancementHolder salvager = Advancements.simpleGetItem(saver, SgBlocks.SALVAGER, crimsonIron);
            AdvancementHolder highDurability = Advancement.Builder.advancement().parent(materialGrader).display(((CompoundPartItem)((Object)SgItems.TIP.get())).create(MaterialInstance.of(Const.Materials.EMERALD)), Advancements.title("high_durability"), Advancements.description("high_durability"), null, AdvancementType.TASK, true, true, false).addCriterion("durability", ((GearPropertyTrigger)((Object)SgCriteriaTriggers.GEAR_PROPERTY.get())).createCriterion((CriterionTriggerInstance)new GearPropertyTrigger.Instance(Optional.empty(), GearProperties.DURABILITY.get(), MinMaxBounds.Doubles.atLeast((double)16000.0)))).save(saver, Advancements.id("high_durability"));
            AdvancementHolder graderCatalyst2 = Advancement.Builder.advancement().parent(materialGrader).display((ItemLike)CraftingItems.BLAZING_DUST, Advancements.title("grader_catalyst_2"), Advancements.description("grader_catalyst_2"), null, AdvancementType.TASK, true, true, false).addCriterion("get_item", Advancements.getItem(SgTags.Items.GRADER_CATALYSTS_TIER_2)).save(saver, Advancements.id("grader_catalyst_2"));
            AdvancementHolder graderCatalyst3 = Advancement.Builder.advancement().parent(graderCatalyst2).display((ItemLike)CraftingItems.GLITTERY_DUST, Advancements.title("grader_catalyst_3"), Advancements.description("grader_catalyst_3"), null, AdvancementType.TASK, true, true, false).addCriterion("get_item", Advancements.getItem(SgTags.Items.GRADER_CATALYSTS_TIER_3)).save(saver, Advancements.id("grader_catalyst_3"));
            AdvancementHolder theEnd = Advancement.Builder.advancement().parent(nether).display((ItemLike)Items.END_STONE, Advancements.title("the_end"), Advancements.description("the_end"), null, AdvancementType.TASK, false, false, false).addCriterion("entered_the_end", ChangeDimensionTrigger.TriggerInstance.changedDimensionTo((ResourceKey)Level.END)).save(saver, Advancements.id("the_end"));
            AdvancementHolder azureSilver = Advancement.Builder.advancement().parent(theEnd).display((ItemLike)CraftingItems.AZURE_SILVER_INGOT, Advancements.title("azure_silver"), Advancements.description("azure_silver"), null, AdvancementType.TASK, true, true, false).addCriterion("get_ore", Advancements.getItem(CraftingItems.RAW_AZURE_SILVER)).addCriterion("get_ingot", Advancements.getItem(CraftingItems.AZURE_SILVER_INGOT)).save(saver, Advancements.id("azure_silver"));
            AdvancementHolder azureElectrum = Advancement.Builder.advancement().parent(azureSilver).display((ItemLike)CraftingItems.AZURE_ELECTRUM_INGOT, Advancements.title("azure_electrum"), Advancements.description("azure_electrum"), null, AdvancementType.TASK, true, true, false).addCriterion("get_ingot", Advancements.getItem(CraftingItems.AZURE_ELECTRUM_INGOT)).save(saver, Advancements.id("azure_electrum"));
            ItemStack azureSilverBoots = new ItemStack((ItemLike)GearItemSets.BOOTS.gearItem());
            GearData.writeConstructionParts(azureSilverBoots, Collections.singleton(PartInstance.create(DataResource.part(GearItemSets.BOOTS.partName()), (CompoundPartItem)GearItemSets.BOOTS.mainPart(), Const.Materials.AZURE_SILVER)));
            GearData.recalculateGearData(azureSilverBoots, null);
            AdvancementHolder moonwalker = Advancement.Builder.advancement().parent(azureSilver).display(azureSilverBoots, Advancements.title("moonwalker"), Advancements.description("moonwalker"), null, AdvancementType.TASK, true, true, false).addCriterion("fall_with_moonwalker_boots", ((PlayerTrigger)SgCriteriaTriggers.FALL_WITH_MOONWALKER.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(Optional.empty()))).save(saver, Advancements.id("moonwalker"));
        }

        private static AdvancementHolder simpleGetItem(Consumer<AdvancementHolder> saver, ItemLike item, AdvancementHolder parent) {
            return Advancements.simpleGetItem(saver, item, parent, NameUtils.fromItem((ItemLike)item).getPath());
        }

        private static AdvancementHolder simpleGetItem(Consumer<AdvancementHolder> saver, ItemLike item, AdvancementHolder parent, String key) {
            return Advancements.simpleGetItem(saver, item, new ItemStack(item), parent, key);
        }

        private static AdvancementHolder simpleGetItem(Consumer<AdvancementHolder> saver, ItemLike item, ItemStack icon, AdvancementHolder parent, String key) {
            return Advancement.Builder.advancement().parent(parent).display(icon, Advancements.title(key), Advancements.description(key), null, AdvancementType.TASK, true, true, false).addCriterion("get_item", Advancements.getItem(item)).save(saver, Advancements.id(key));
        }

        private static String id(String path) {
            return SilentGear.getId(path).toString();
        }

        private static Criterion<InventoryChangeTrigger.TriggerInstance> getItem(ItemLike ... items) {
            return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items);
        }

        private static Criterion<InventoryChangeTrigger.TriggerInstance> getItem(TagKey<Item> tag) {
            return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(tag).build()});
        }

        private static Component title(String key) {
            return Component.translatable((String)("advancements.silentgear." + key + ".title"));
        }

        private static Component description(String key) {
            return Component.translatable((String)("advancements.silentgear." + key + ".description"));
        }
    }
}

