/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.loot;

import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.setup.SgBlocks;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.lib.util.NameUtils;

public class ModBlockLootTables
extends BlockLootSubProvider {
    protected ModBlockLootTables(HolderLookup.Provider provider) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.add((Block)SgBlocks.BORT_ORE.get(), this.createOreDrop((Block)SgBlocks.BORT_ORE.get(), CraftingItems.BORT.asItem()));
        this.add((Block)SgBlocks.DEEPSLATE_BORT_ORE.get(), this.createOreDrop((Block)SgBlocks.DEEPSLATE_BORT_ORE.get(), CraftingItems.BORT.asItem()));
        this.add((Block)SgBlocks.CRIMSON_IRON_ORE.get(), this.createOreDrop((Block)SgBlocks.CRIMSON_IRON_ORE.get(), CraftingItems.RAW_CRIMSON_IRON.asItem()));
        this.add((Block)SgBlocks.BLACKSTONE_CRIMSON_IRON_ORE.get(), this.createOreDrop((Block)SgBlocks.BLACKSTONE_CRIMSON_IRON_ORE.get(), CraftingItems.RAW_CRIMSON_IRON.asItem()));
        this.add((Block)SgBlocks.AZURE_SILVER_ORE.get(), this.createOreDrop((Block)SgBlocks.AZURE_SILVER_ORE.get(), CraftingItems.RAW_AZURE_SILVER.asItem()));
        this.dropSelf((Block)SgBlocks.RAW_CRIMSON_IRON_BLOCK.get());
        this.dropSelf((Block)SgBlocks.RAW_AZURE_SILVER_BLOCK.get());
        this.dropSelf((Block)SgBlocks.BLAZE_GOLD_BLOCK.get());
        this.dropSelf((Block)SgBlocks.BORT_BLOCK.get());
        this.dropSelf((Block)SgBlocks.CRIMSON_IRON_BLOCK.get());
        this.dropSelf((Block)SgBlocks.CRIMSON_STEEL_BLOCK.get());
        this.dropSelf((Block)SgBlocks.AZURE_SILVER_BLOCK.get());
        this.dropSelf((Block)SgBlocks.AZURE_ELECTRUM_BLOCK.get());
        this.dropSelf((Block)SgBlocks.TYRIAN_STEEL_BLOCK.get());
        this.dropSelf((Block)SgBlocks.MATERIAL_GRADER.get());
        this.dropSelf((Block)SgBlocks.NETHERWOOD_CHARCOAL_BLOCK.get());
        this.dropSelf((Block)SgBlocks.NETHERWOOD_FENCE.get());
        this.dropSelf((Block)SgBlocks.NETHERWOOD_FENCE_GATE.get());
        this.add((Block)SgBlocks.NETHERWOOD_LEAVES.get(), block -> this.createNetherwoodLeaves((Block)block, (Block)SgBlocks.NETHERWOOD_SAPLING.get(), 0.05f, 0.0625f, 0.083333336f, 0.1f));
        this.dropSelf((Block)SgBlocks.NETHERWOOD_LOG.get());
        this.dropSelf((Block)SgBlocks.STRIPPED_NETHERWOOD_LOG.get());
        this.dropSelf((Block)SgBlocks.NETHERWOOD_WOOD.get());
        this.dropSelf((Block)SgBlocks.STRIPPED_NETHERWOOD_WOOD.get());
        this.dropSelf((Block)SgBlocks.NETHERWOOD_PLANKS.get());
        this.dropSelf((Block)SgBlocks.NETHERWOOD_SAPLING.get());
        this.add((Block)SgBlocks.NETHERWOOD_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
        this.dropSelf((Block)SgBlocks.NETHERWOOD_TRAPDOOR.get());
        this.add((Block)SgBlocks.NETHERWOOD_SLAB.get(), x$0 -> this.createSlabItemTable((Block)x$0));
        this.dropSelf((Block)SgBlocks.NETHERWOOD_STAIRS.get());
        this.dropSelf((Block)SgBlocks.STONE_TORCH.get());
        this.add((Block)SgBlocks.PHANTOM_LIGHT.get(), ModBlockLootTables.noDrop());
        this.dropPottedContents((Block)SgBlocks.POTTED_NETHERWOOD_SAPLING.get());
        this.dropSelf((Block)SgBlocks.GEAR_SMITHING_TABLE.get());
        this.dropSelf((Block)SgBlocks.ALLOY_FORGE.get());
        this.dropSelf((Block)SgBlocks.METAL_PRESS.get());
        this.dropSelf((Block)SgBlocks.RECRYSTALLIZER.get());
        this.dropSelf((Block)SgBlocks.REFABRICATOR.get());
        this.dropSelf((Block)SgBlocks.SALVAGER.get());
        this.dropSelf((Block)SgBlocks.STARLIGHT_CHARGER.get());
        this.dropSelf((Block)SgBlocks.STONE_ANVIL.get());
        this.dropSelf((Block)SgBlocks.SUPER_MIXER.get());
        this.dropSelf((Block)SgBlocks.WHITE_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.ORANGE_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.MAGENTA_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.YELLOW_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.LIME_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.PINK_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.GRAY_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.CYAN_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.PURPLE_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.BLUE_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.BROWN_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.GREEN_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.RED_FLUFFY_BLOCK.get());
        this.dropSelf((Block)SgBlocks.BLACK_FLUFFY_BLOCK.get());
        this.add((Block)SgBlocks.FLAX_PLANT.get(), this.flaxPlant((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)SgBlocks.FLAX_PLANT.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7))));
        this.dropOther((Block)SgBlocks.WILD_FLAX_PLANT.get(), (ItemLike)SgItems.FLAX_SEEDS);
        this.add((Block)SgBlocks.FLUFFY_PLANT.get(), this.fluffyPlant((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)SgBlocks.FLUFFY_PLANT.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7))));
        this.dropOther((Block)SgBlocks.WILD_FLUFFY_PLANT.get(), (ItemLike)SgItems.FLUFFY_SEEDS);
    }

    private LootTable.Builder createNetherwoodLeaves(Block leavesBlock, Block saplingBlock, float ... chances) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchOrShearsDispatchTable(leavesBlock, ((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)saplingBlock))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])chances))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leavesBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)CraftingItems.NETHERWOOD_STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(this.doesNotHaveShearsOrSilkTouch()).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leavesBlock, (ConditionUserBuilder)LootItem.lootTableItem(SgItems.NETHER_BANANA))).when(BonusLevelTableCondition.bonusLevelFlatChance((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE), (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    private LootTable.Builder flaxPlant(LootItemCondition.Builder builder) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference fortune = registrylookup.getOrThrow(Enchantments.FORTUNE);
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)SgBlocks.FLAX_PLANT, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when(builder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.FLAX_FIBER).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)3)))).withPool(LootPool.lootPool().when(builder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SgItems.FLAX_SEEDS).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)3)))).withPool(LootPool.lootPool().when(builder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.FLAX_FLOWERS).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5f, (int)1)))));
    }

    private LootTable.Builder fluffyPlant(LootItemCondition.Builder builder) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        Holder.Reference fortune = registrylookup.getOrThrow(Enchantments.FORTUNE);
        return (LootTable.Builder)this.applyExplosionDecay((ItemLike)SgBlocks.FLUFFY_PLANT, (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().when(builder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)CraftingItems.FLUFFY_PUFF).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)3)))).withPool(LootPool.lootPool().when(builder).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(SgItems.FLUFFY_SEEDS).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)fortune, (float)0.5714286f, (int)3)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> "silentgear".equals(NameUtils.fromBlock((Block)block).getNamespace())).collect(Collectors.toSet());
    }

    private LootItemCondition.Builder hasShearsOrSilkTouch() {
        return HAS_SHEARS.or(this.hasSilkTouch());
    }

    private LootItemCondition.Builder doesNotHaveShearsOrSilkTouch() {
        return this.hasShearsOrSilkTouch().invert();
    }
}

