/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.silentchaos512.gear.api.event.GetMaterialPropertiesEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.material.MaterialCraftingData;
import net.silentchaos512.gear.api.material.MaterialDisplayData;
import net.silentchaos512.gear.api.material.MaterialSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.material.AbstractMaterial;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.MathUtils;

public class CompoundMaterial
extends AbstractMaterial {
    public CompoundMaterial(DataResource<Material> parent, MaterialCraftingData crafting, MaterialDisplayData display) {
        super(parent, crafting, display, Collections.emptyMap());
    }

    public List<MaterialInstance> getSubMaterials(MaterialInstance material) {
        return CompoundMaterialItem.getSubMaterials(material.getItem());
    }

    @Override
    public MaterialSerializer<?> getSerializer() {
        return MaterialSerializers.COMPOUND.get();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    @Nullable
    public Material getParent() {
        return null;
    }

    @Override
    public Collection<IMaterialCategory> getCategories(MaterialInstance material) {
        HashSet<IMaterialCategory> set = new HashSet<IMaterialCategory>(this.crafting.categories());
        for (MaterialInstance mat : this.getSubMaterials(material)) {
            if (!mat.isValid()) continue;
            set.addAll(mat.getCategories());
        }
        return set;
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.empty();
    }

    @Override
    public boolean hasPartSubstitutes() {
        return false;
    }

    @Override
    public boolean canSalvage() {
        return false;
    }

    @Override
    public Set<PartType> getPartTypes(MaterialInstance material) {
        List<MaterialInstance> subMaterials = this.getSubMaterials(material).stream().filter(MaterialInstance::isValid).toList();
        if (subMaterials.isEmpty()) {
            return Collections.emptySet();
        }
        if (subMaterials.size() == 1) {
            return subMaterials.getFirst().getPartTypes();
        }
        LinkedHashSet<PartType> set = new LinkedHashSet<PartType>(subMaterials.getFirst().getPartTypes());
        for (int i = 1; i < subMaterials.size(); ++i) {
            Set<PartType> set1 = subMaterials.get(i).getPartTypes();
            HashSet<PartType> toRemove = new HashSet<PartType>();
            for (PartType type : set) {
                if (set1.contains(type) && this.isValidMaterialSet(subMaterials, type)) continue;
                toRemove.add(type);
            }
            set.removeAll(toRemove);
        }
        return set;
    }

    private boolean isValidMaterialSet(List<MaterialInstance> materials, PartType partType) {
        for (MaterialInstance material : materials) {
            if (((Boolean)material.getProperty(partType, GearProperties.ADDITIVE.get())).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllowedInPart(MaterialInstance material, PartType partType) {
        return this.getPartTypes(material).contains(partType);
    }

    @Override
    public Collection<PropertyKey<?, ?>> getPropertyKeys(MaterialInstance material, PartType type) {
        return this.getSubMaterials(material).stream().filter(MaterialInstance::isValid).flatMap(mat -> mat.get().getPropertyKeys((MaterialInstance)mat, type).stream()).collect(Collectors.toSet());
    }

    @Override
    public <T, V extends GearPropertyValue<T>> Collection<V> getPropertyModifiers(MaterialInstance material, PartType partType, PropertyKey<T, V> key) {
        List<MaterialInstance> subMaterials = this.getSubMaterials(material);
        List<GearPropertyValue<?>> propertyMods = subMaterials.stream().filter(MaterialInstance::isValid).map(AbstractMaterial::removeEnhancements).flatMap(m -> m.getPropertyModifiers(partType, key).stream()).collect(Collectors.toList());
        if (propertyMods.isEmpty()) {
            return propertyMods;
        }
        List<GearPropertyValue<?>> castedPropertyMods = propertyMods;
        GetMaterialPropertiesEvent event = new GetMaterialPropertiesEvent(material, partType, key.property(), castedPropertyMods);
        NeoForge.EVENT_BUS.post((Event)event);
        ArrayList modifiersFromEvent = new ArrayList(event.getModifiers());
        PartGearKey partGearKey = PartGearKey.ofAll(partType);
        List<GearPropertyValue<?>> compressedModifiers = key.property().compressModifiers(modifiersFromEvent, partGearKey, subMaterials);
        ArrayList modifiersWithSynergy = new ArrayList();
        if (key.property().isAffectedBySynergy()) {
            float synergy = SynergyUtils.getSynergy(partType, new ArrayList<MaterialInstance>(subMaterials), material.getTraits(partGearKey));
            if (!MathUtils.floatsEqual((float)synergy, (float)1.0f)) {
                for (GearPropertyValue<?> mod : compressedModifiers) {
                    modifiersWithSynergy.add(key.property().applySynergy(mod, synergy));
                }
            }
            return modifiersWithSynergy;
        }
        return compressedModifiers;
    }

    @Override
    public boolean isCraftingAllowed(MaterialInstance material, PartType partType, GearType gearType, @Nullable CraftingInput craftingInput) {
        if (!this.isAllowedInPart(material, partType)) {
            return false;
        }
        if (partType == PartTypes.MAIN.get()) {
            PropertyKey key = PropertyKey.of(gearType.durabilityStat().get(), gearType);
            return !this.getPropertyModifiers(material, partType, key).isEmpty() && ((Float)this.getPropertyUnclamped(material, partType, key)).floatValue() > 0.0f;
        }
        return true;
    }

    @Override
    public Component getDisplayName(@Nullable MaterialInstance material, PartType type) {
        if (material != null) {
            return material.getItem().getHoverName();
        }
        return this.display.name().copy();
    }

    @Override
    public int getColor(MaterialInstance material, PartType partType, GearType gearType) {
        return ColorUtils.getBlendedColorForCompoundMaterial(this.getSubMaterials(material));
    }

    @Override
    public int getNameColor(MaterialInstance material, PartType partType, GearType gearType) {
        int color = this.getColor(material, partType, gearType);
        return Color.blend((int)color, (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
    }

    @Override
    public String getModelKey(MaterialInstance material) {
        String commaSeparatedMaterialList = this.getSubMaterials(material).stream().filter(MaterialInstance::isValid).map(MaterialInstance::getModelKey).collect(Collectors.joining(","));
        return super.getModelKey(material) + "[" + commaSeparatedMaterialList + "]";
    }

    @Override
    public String toString() {
        return "CompoundMaterial{" + String.valueOf(SgRegistries.MATERIAL.getKey(this)) + "}";
    }

    public static final class Serializer
    extends MaterialSerializer<CompoundMaterial> {
        public static final MapCodec<CompoundMaterial> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DataResource.MATERIAL_CODEC.fieldOf("parent").forGetter(m -> m.parent), (App)MaterialCraftingData.CODEC.fieldOf("crafting").forGetter(m -> m.crafting), (App)MaterialDisplayData.CODEC.fieldOf("display").forGetter(m -> m.display)).apply((Applicative)instance, CompoundMaterial::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CompoundMaterial> STREAM_CODEC = StreamCodec.composite(DataResource.MATERIAL_STREAM_CODEC, m -> m.parent, MaterialCraftingData.STREAM_CODEC, m -> m.crafting, MaterialDisplayData.STREAM_CODEC, m -> m.display, CompoundMaterial::new);

        public Serializer() {
            super(CODEC, STREAM_CODEC);
        }
    }
}

