/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.silentchaos512.gear.Config;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearItem;
import net.silentchaos512.gear.api.item.GearTool;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.TextureType;
import net.silentchaos512.gear.api.part.GearPart;
import net.silentchaos512.gear.api.part.PartList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.property.GearProperty;
import net.silentchaos512.gear.api.property.GearPropertyMap;
import net.silentchaos512.gear.api.property.GearPropertyValue;
import net.silentchaos512.gear.api.property.TraitListPropertyValue;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.api.util.PropertyKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.core.component.GearConstructionData;
import net.silentchaos512.gear.core.component.GearPropertiesData;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartInstance;
import net.silentchaos512.gear.item.gear.GearArmorItem;
import net.silentchaos512.gear.setup.SgDataComponents;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.setup.gear.GearProperties;
import net.silentchaos512.gear.setup.gear.PartTypes;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.util.NameUtils;
import org.jetbrains.annotations.Nullable;

public final class GearData {
    private GearData() {
        throw new IllegalAccessError("Utility class");
    }

    public static GearPropertiesData getProperties(ItemStack gear) {
        return GearData.getProperties(gear, null);
    }

    public static GearPropertiesData getProperties(ItemStack gear, @javax.annotation.Nullable Player player) {
        GearPropertiesData data = (GearPropertiesData)gear.get(SgDataComponents.GEAR_PROPERTIES);
        if (data != null) {
            return data;
        }
        GearData.recalculateGearData(gear, null);
        return (GearPropertiesData)gear.getOrDefault(SgDataComponents.GEAR_PROPERTIES, (Object)GearPropertiesData.EMPTY);
    }

    public static GearConstructionData getConstruction(ItemStack gear) {
        if (!(gear.getItem() instanceof GearItem)) {
            throw new IllegalArgumentException("Not a gear item: " + String.valueOf(gear));
        }
        return (GearConstructionData)gear.getOrDefault(SgDataComponents.GEAR_CONSTRUCTION, (Object)GearConstructionData.EMPTY);
    }

    public static void recalculateGearData(ItemStack gear, @javax.annotation.Nullable Player player) {
        GearConstructionData gearConstructionData = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        try {
            GearType gearType = GearHelper.getType(gear);
            GearData.tryRecalculateGearData(gear, player, gearType, gearConstructionData);
        }
        catch (Throwable ex) {
            CrashReport report = CrashReport.forThrowable((Throwable)ex, (String)"Failed to recalculate gear item properties");
            CrashReportCategory itemCategory = report.addCategory("Gear Item");
            itemCategory.setDetail("Name", (Object)(gear.getHoverName().getString() + " (" + String.valueOf(NameUtils.fromItem((ItemStack)gear)) + ")"));
            itemCategory.setDetail("Data", gearConstructionData != null ? gearConstructionData : "null");
            throw new ReportedException(report);
        }
    }

    private static void tryRecalculateGearData(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType, GearConstructionData gearConstructionData) {
        if (gearConstructionData == null) {
            return;
        }
        PartList parts = gearConstructionData.parts();
        if (parts.isEmpty() || parts.getMains().isEmpty()) {
            SilentGear.LOGGER.debug("Not recalculating stats for {}", (Object)GearData.getPlayersItemNameText(gear, player));
        }
        GearPropertiesData oldProperties = (GearPropertiesData)gear.get(SgDataComponents.GEAR_PROPERTIES);
        GearData.onRecalculatePre(gear, player, oldProperties, gearConstructionData);
        GearPropertiesData baseProperties = GearData.calculateBaseProperties(gear, player, gearType, gearConstructionData);
        gear.set(SgDataComponents.GEAR_BASE_PROPERTIES, (Object)baseProperties);
        GearPropertyMap bonusValues = GearData.calculateBonusProperties(gear, player, gearType);
        gear.set(SgDataComponents.GEAR_BONUS_PROPERTIES, (Object)bonusValues);
        GearPropertiesData finalProperties = GearData.calculateFinalProperties(gear, player, gearType);
        gear.set(SgDataComponents.GEAR_PROPERTIES, (Object)finalProperties);
        GearData.printStatsForDebugging(gear, oldProperties, baseProperties, bonusValues, finalProperties);
        GearData.onRecalculatePost(gear, player, finalProperties);
    }

    private static void onRecalculatePre(ItemStack gear, @javax.annotation.Nullable Player player, @javax.annotation.Nullable GearPropertiesData oldProperties, GearConstructionData gearConstructionData) {
        Component itemName = GearHelper.getItemName(gear, gearConstructionData);
        if (itemName != null) {
            gear.set(DataComponents.ITEM_NAME, (Object)itemName);
        }
        if (oldProperties == null) {
            return;
        }
        gear.remove(DataComponents.ATTRIBUTE_MODIFIERS);
        for (TraitInstance trait : oldProperties.getTraits()) {
            if (!trait.isValid()) continue;
            trait.getTrait().onRecalculatePre(gear, trait.getLevel());
        }
    }

    private static void onRecalculatePost(ItemStack gear, @javax.annotation.Nullable Player player, GearPropertiesData finalProperties) {
        Item item = gear.getItem();
        if (item instanceof GearTool) {
            GearTool gearTool = (GearTool)item;
            GearPropertiesData properties = (GearPropertiesData)gear.getOrDefault(SgDataComponents.GEAR_PROPERTIES, (Object)GearPropertiesData.EMPTY);
            gear.set(DataComponents.TOOL, (Object)gearTool.createToolProperties(properties));
        }
        int modelIndex = GearData.calculateModelIndex(gear);
        gear.set(SgDataComponents.GEAR_MODEL_INDEX, (Object)modelIndex);
        String modelKey = GearData.calculateModelKey(gear, GearData.getConstruction(gear).parts());
        gear.set(SgDataComponents.GEAR_MODEL_KEY, (Object)modelKey);
        if (gear.is(ItemTags.DYEABLE)) {
            int color = GearArmorItem.getArmorColor(gear);
            gear.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(color, false));
        }
        for (TraitInstance trait : finalProperties.getTraits()) {
            trait.getTrait().onRecalculatePost(gear, trait.getLevel());
        }
    }

    private static GearPropertiesData calculateBaseProperties(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType, GearConstructionData gearConstructionData) {
        PartList parts = gearConstructionData.parts();
        GearPropertyMap propertyMods = parts.getPropertyModifiersFromParts(gearType);
        LinkedHashMap finalBaseValues = new LinkedHashMap();
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (property.isForMaterialsOnly()) continue;
            PropertyKey key = PropertyKey.of(property, gearType);
            Collection<GearPropertyValue<?>> modifiers = propertyMods.get(key);
            GearType statGearType = propertyMods.getMostSpecificKey(key).gearType();
            Object value = property.computeUncheckedForGear(gearType, statGearType, modifiers, parts);
            finalBaseValues.put(property, (GearPropertyValue<?>)value);
        }
        return new GearPropertiesData(finalBaseValues);
    }

    private static GearPropertyMap calculateBonusProperties(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType) {
        GearPropertiesData baseProperties = (GearPropertiesData)gear.getOrDefault(SgDataComponents.GEAR_BASE_PROPERTIES, (Object)GearPropertiesData.EMPTY);
        GearPropertyMap bonusProperties = new GearPropertyMap();
        List traits = (List)baseProperties.getOrDefault(GearProperties.TRAITS, TraitListPropertyValue.empty()).value();
        Integer damageValue = (Integer)gear.getOrDefault(DataComponents.DAMAGE, (Object)0);
        int baseDurability = gearType.getBaseDurability(baseProperties);
        float damageRatio = Mth.clamp((float)((float)damageValue.intValue() / (float)baseDurability), (float)0.0f, (float)1.0f);
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (property == GearProperties.TRAITS || !baseProperties.contains(property)) continue;
            PropertyKey key = PropertyKey.of(property, gearType);
            for (TraitInstance trait : traits) {
                Object baseValue = baseProperties.get(property);
                assert (baseValue != null);
                bonusProperties.putAll(key, trait.getTrait().getBonusProperties(trait.getLevel(), player, property, (GearPropertyValue<?>)baseValue, damageRatio));
            }
            GearPropertyValue<?> configBonus = Config.Common.getPropertyBonusMultiplier(property);
            if (configBonus == null) continue;
            bonusProperties.put(key, configBonus);
        }
        return bonusProperties;
    }

    private static GearPropertiesData calculateFinalProperties(ItemStack gear, @javax.annotation.Nullable Player player, GearType gearType) {
        GearPropertiesData baseProperties = (GearPropertiesData)gear.getOrDefault(SgDataComponents.GEAR_BASE_PROPERTIES, (Object)GearPropertiesData.EMPTY);
        GearPropertyMap bonusProperties = (GearPropertyMap)gear.getOrDefault(SgDataComponents.GEAR_BONUS_PROPERTIES, (Object)GearPropertyMap.EMPTY);
        GearPropertyMap combinedMods = new GearPropertyMap();
        LinkedHashMap finalValues = new LinkedHashMap();
        for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
            if (!baseProperties.contains(property)) continue;
            PropertyKey key = PropertyKey.of(property, gearType);
            combinedMods.put(key, (GearPropertyValue<?>)baseProperties.get(property));
            combinedMods.putAll(key, bonusProperties.get(key));
            finalValues.put(property, (GearPropertyValue<?>)property.computeUnchecked(true, gearType, gearType, combinedMods.get(key)));
        }
        return new GearPropertiesData(finalValues);
    }

    private static void modifyEnchantmentData(ItemStack gear, @javax.annotation.Nullable Player player) {
        String playersItemText = GearData.getPlayersItemNameText(gear, player);
        if (gear.isEnchanted() && ((Boolean)Config.Common.forceRemoveEnchantments.get()).booleanValue()) {
            SilentGear.LOGGER.debug("Forcibly removing all enchantments from {} as per config settings", (Object)playersItemText);
            gear.set(DataComponents.ENCHANTMENTS, null);
        }
    }

    private static String getPlayersItemNameText(ItemStack gear, @Nullable Player player) {
        String playerName = player != null ? player.getScoreboardName() : "somebody";
        return String.format("%s's %s", playerName, gear.getHoverName().getString());
    }

    private static void printStatsForDebugging(ItemStack stack, @javax.annotation.Nullable GearPropertiesData oldProperties, GearPropertiesData baseProperties, GearPropertyMap bonusValues, GearPropertiesData newProperties) {
        if (oldProperties != null && Config.Common.isLoaded() && ((Boolean)Config.Common.propertiesDebugLogging.get()).booleanValue()) {
            SilentGear.LOGGER.debug("{}: properties updated", (Object)stack.getDisplayName().getString());
            GearType gearType = GearHelper.getType(stack);
            for (GearProperty property : SgRegistries.GEAR_PROPERTY) {
                Object oldValue = oldProperties.get(property);
                Object newValue = newProperties.get(property);
                SilentGear.LOGGER.debug(" - {}: {} -> {} -- base: {}, bonuses: [{}]", (Object)property.getDisplayName().getString(), oldValue, newValue, baseProperties.get(property), bonusValues.get(PropertyKey.of(property, gearType)));
            }
        }
    }

    public static String getModelKey(ItemStack stack, int animationFrame) {
        String key = (String)stack.get(SgDataComponents.GEAR_MODEL_KEY);
        if (key == null) {
            return "null";
        }
        return key + (String)(animationFrame > 0 ? "_" + animationFrame : "");
    }

    private static String calculateModelKey(ItemStack stack, Collection<? extends PartInstance> parts) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + ":");
        for (PartInstance partInstance : parts) {
            s.append(partInstance.getModelKey()).append(',');
        }
        return s.toString();
    }

    private static int calculateModelIndex(ItemStack gear) {
        int ret;
        if (GearHelper.isBroken(gear)) {
            return 0;
        }
        GearConstructionData data = GearData.getConstruction(gear);
        PartInstance coatingOrMainPart = data.getCoatingOrMainPart();
        if (coatingOrMainPart == null || coatingOrMainPart.getPrimaryMaterial() == null) {
            return -1;
        }
        MaterialInstance mainMaterial = coatingOrMainPart.getPrimaryMaterial();
        boolean highContrast = mainMaterial.getMainTextureType() == TextureType.HIGH_CONTRAST;
        int n = ret = highContrast ? 3 : 2;
        if (GearData.getPartOfType(gear, (PartType)PartTypes.TIP.get()) != null) {
            ret |= 4;
        }
        if (GearData.getPartOfType(gear, (PartType)PartTypes.GRIP.get()) != null) {
            ret |= 8;
        }
        return ret;
    }

    public static int getModelIndex(ItemStack stack) {
        return (Integer)stack.getOrDefault(SgDataComponents.GEAR_MODEL_INDEX, (Object)0);
    }

    @javax.annotation.Nullable
    public static PartInstance getPartOfType(ItemStack stack, PartType type) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data == null) {
            return null;
        }
        for (PartInstance part : data.parts()) {
            if (part.getType() != type) continue;
            return part;
        }
        return null;
    }

    public static boolean hasPartOfType(ItemStack stack, PartType type) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data == null) {
            return false;
        }
        for (PartInstance part : data.parts()) {
            if (part.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static void addUpgradePart(ItemStack gear, PartInstance part) {
        if (!GearHelper.isGear(gear) || !part.isValid()) {
            return;
        }
        ArrayList<PartInstance> parts = new ArrayList<PartInstance>(GearData.getConstruction(gear).parts());
        if (!part.get().canAddToGear(gear, part)) {
            return;
        }
        if (part.get().replacesExistingInPosition(part)) {
            parts.removeIf(p -> p.getType() == part.getType());
        }
        part.onAddToGear(gear);
        for (PartInstance partInList : parts) {
            if (partInList.get() != part.get()) continue;
            return;
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static boolean hasPart(ItemStack gear, PartType partType, Predicate<PartInstance> predicate) {
        for (PartInstance partData : GearData.getConstruction(gear).parts()) {
            if (!predicate.test(partData)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(ItemStack gear, GearPart part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        for (PartInstance partInstance : GearData.getConstruction(gear).parts()) {
            if (!partInstance.isValid() || partInstance.get() != part) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPart(ItemStack gear, DataResource<GearPart> part) {
        if (GearData.checkNonGearItem(gear, "hasPart")) {
            return false;
        }
        String partId = part.getId().toString();
        return GearData.hasPart(gear, partId);
    }

    private static boolean hasPart(ItemStack gear, String partId) {
        GearConstructionData data = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data == null) {
            return false;
        }
        for (PartInstance part : data.parts()) {
            if (!part.getId().toString().equalsIgnoreCase(partId)) continue;
            return true;
        }
        return false;
    }

    public static void addOrReplacePart(ItemStack gear, PartInstance part) {
        PartType partType = part.getType();
        PartList parts = GearData.getConstruction(gear).parts();
        List<PartInstance> partsOfType = parts.getPartsOfType(partType);
        PartInstance removedPart = null;
        if (!partsOfType.isEmpty() && partsOfType.size() >= partType.maxPerItem()) {
            removedPart = partsOfType.getFirst();
            parts.remove(removedPart);
            removedPart.onRemoveFromGear(gear);
        }
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
    }

    public static void addPart(ItemStack gear, PartInstance part) {
        PartList parts = GearData.getConstruction(gear).parts();
        parts.add(part);
        GearData.writeConstructionParts(gear, parts);
        part.onAddToGear(gear);
    }

    public static boolean removeFirstPartOfType(ItemStack gear, PartType type) {
        PartList parts = GearData.getConstruction(gear).parts();
        ArrayList<PartInstance> partsMutable = new ArrayList<PartInstance>(parts);
        ArrayList<PartInstance> partsOfType = new ArrayList<PartInstance>(parts.getPartsOfType(type));
        if (!partsOfType.isEmpty()) {
            PartInstance removed = (PartInstance)partsOfType.removeFirst();
            partsMutable.remove(removed);
            GearData.writeConstructionParts(gear, partsMutable);
            removed.onRemoveFromGear(gear);
            return true;
        }
        return false;
    }

    public static void writeConstructionParts(ItemStack gear, Collection<PartInstance> parts) {
        if (GearData.checkNonGearItem(gear, "writeConstructionParts")) {
            return;
        }
        GearConstructionData data = (GearConstructionData)gear.get(SgDataComponents.GEAR_CONSTRUCTION);
        GearConstructionData newData = new GearConstructionData(PartList.immutable(parts), data != null && data.isExample(), data != null ? data.brokenCount() : 0, data != null ? data.repairedCount() : 0);
        gear.set(SgDataComponents.GEAR_CONSTRUCTION, (Object)newData);
    }

    public static boolean isExampleGear(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null && data.isExample();
    }

    public static int getBrokenCount(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null ? data.brokenCount() : 0;
    }

    static void incrementBrokenCount(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data != null) {
            GearConstructionData newData = new GearConstructionData(data.parts(), data.isExample(), data.brokenCount() + 1, data.repairedCount());
            stack.set(SgDataComponents.GEAR_CONSTRUCTION, (Object)newData);
        }
    }

    public static int getRepairedCount(ItemStack stack) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        return data != null ? data.repairedCount() : 0;
    }

    public static void incrementRepairedCount(ItemStack stack, int amount) {
        GearConstructionData data = (GearConstructionData)stack.get(SgDataComponents.GEAR_CONSTRUCTION);
        if (data != null) {
            GearConstructionData newData = new GearConstructionData(data.parts(), data.isExample(), data.brokenCount(), data.repairedCount() + 1);
            stack.set(SgDataComponents.GEAR_CONSTRUCTION, (Object)newData);
        }
    }

    private static boolean checkNonGearItem(ItemStack stack, String methodName) {
        if (GearHelper.isGear(stack)) {
            return false;
        }
        SilentGear.LOGGER.error("Called {} on non-gear item, {}", (Object)methodName, (Object)stack);
        SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
        return true;
    }

    public static void setExampleTag(ItemStack result, boolean value) {
        result.set(SgDataComponents.GEAR_IS_EXAMPLE, (Object)value);
    }

    @EventBusSubscriber(modid="silentgear")
    public static final class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            StackList.from((Container)player.getInventory()).stream().filter(s -> s.getItem() instanceof GearItem).forEach(s -> GearData.recalculateGearData(s, player));
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.getEquippedCurios((LivingEntity)player).forEach(s -> GearData.recalculateGearData(s, player));
            }
        }
    }
}

