/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.mcreator.butcher.init.ButcherModBlockEntities;
import net.mcreator.butcher.init.ButcherModBlocks;
import net.mcreator.butcher.init.ButcherModEntities;
import net.mcreator.butcher.init.ButcherModFeatures;
import net.mcreator.butcher.init.ButcherModFluidTypes;
import net.mcreator.butcher.init.ButcherModFluids;
import net.mcreator.butcher.init.ButcherModItems;
import net.mcreator.butcher.init.ButcherModMenus;
import net.mcreator.butcher.init.ButcherModMobEffects;
import net.mcreator.butcher.init.ButcherModParticleTypes;
import net.mcreator.butcher.init.ButcherModPotions;
import net.mcreator.butcher.init.ButcherModSounds;
import net.mcreator.butcher.init.ButcherModTabs;
import net.mcreator.butcher.network.ButcherModVariables;
import net.mcreator.butcher.world.features.StructureFeature;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="butcher")
public class ButcherMod {
    public static final Logger LOGGER = LogManager.getLogger(ButcherMod.class);
    public static final String MODID = "butcher";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public ButcherMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        ButcherModSounds.REGISTRY.register(modEventBus);
        ButcherModBlocks.REGISTRY.register(modEventBus);
        ButcherModBlockEntities.REGISTRY.register(modEventBus);
        ButcherModItems.REGISTRY.register(modEventBus);
        ButcherModEntities.REGISTRY.register(modEventBus);
        ButcherModTabs.REGISTRY.register(modEventBus);
        ButcherModVariables.ATTACHMENT_TYPES.register(modEventBus);
        ButcherModFeatures.REGISTRY.register(modEventBus);
        StructureFeature.REGISTRY.register(modEventBus);
        ButcherModPotions.REGISTRY.register(modEventBus);
        ButcherModMobEffects.REGISTRY.register(modEventBus);
        ButcherModMenus.REGISTRY.register(modEventBus);
        ButcherModParticleTypes.REGISTRY.register(modEventBus);
        ButcherModFluids.REGISTRY.register(modEventBus);
        ButcherModFluidTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

