/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EmptyskinrackBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public EmptyskinrackBlock() {
        super(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)EmptyskinrackBlock.box((double)-0.5004, (double)0.0, (double)1.4, (double)16.4998, (double)5.0, (double)14.9), (VoxelShape[])new VoxelShape[]{EmptyskinrackBlock.box((double)-0.5004, (double)5.0, (double)3.4, (double)16.4998, (double)10.0, (double)12.9), EmptyskinrackBlock.box((double)-0.5004, (double)10.0, (double)5.4, (double)16.4998, (double)15.0, (double)10.9)});
            case Direction.NORTH -> Shapes.or((VoxelShape)EmptyskinrackBlock.box((double)-0.4998, (double)0.0, (double)1.1, (double)16.5004, (double)5.0, (double)14.6), (VoxelShape[])new VoxelShape[]{EmptyskinrackBlock.box((double)-0.4998, (double)5.0, (double)3.1, (double)16.5004, (double)10.0, (double)12.6), EmptyskinrackBlock.box((double)-0.4998, (double)10.0, (double)5.1, (double)16.5004, (double)15.0, (double)10.6)});
            case Direction.EAST -> Shapes.or((VoxelShape)EmptyskinrackBlock.box((double)1.4, (double)0.0, (double)-0.4998, (double)14.9, (double)5.0, (double)16.5004), (VoxelShape[])new VoxelShape[]{EmptyskinrackBlock.box((double)3.4, (double)5.0, (double)-0.4998, (double)12.9, (double)10.0, (double)16.5004), EmptyskinrackBlock.box((double)5.4, (double)10.0, (double)-0.4998, (double)10.9, (double)15.0, (double)16.5004)});
            case Direction.WEST -> Shapes.or((VoxelShape)EmptyskinrackBlock.box((double)1.1, (double)0.0, (double)-0.5004, (double)14.6, (double)5.0, (double)16.4998), (VoxelShape[])new VoxelShape[]{EmptyskinrackBlock.box((double)3.1, (double)5.0, (double)-0.5004, (double)12.6, (double)10.0, (double)16.4998), EmptyskinrackBlock.box((double)5.1, (double)10.0, (double)-0.5004, (double)10.6, (double)15.0, (double)16.4998)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

