/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.mcreator.butcher.procedures.ShouldBleedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PigCorpseSkeletonBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public PigCorpseSkeletonBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.BONE_BLOCK).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)PigCorpseSkeletonBlock.box((double)0.0473, (double)0.10082, (double)3.19482, (double)15.8473, (double)9.90082, (double)10.99482), (VoxelShape)PigCorpseSkeletonBlock.box((double)-1.0, (double)4.025, (double)5.0, (double)1.0, (double)6.025, (double)7.0));
            case Direction.NORTH -> Shapes.or((VoxelShape)PigCorpseSkeletonBlock.box((double)0.1527, (double)0.10082, (double)5.00518, (double)15.9527, (double)9.90082, (double)12.80518), (VoxelShape)PigCorpseSkeletonBlock.box((double)15.0, (double)4.025, (double)9.0, (double)17.0, (double)6.025, (double)11.0));
            case Direction.EAST -> Shapes.or((VoxelShape)PigCorpseSkeletonBlock.box((double)3.19482, (double)0.10082, (double)0.1527, (double)10.99482, (double)9.90082, (double)15.9527), (VoxelShape)PigCorpseSkeletonBlock.box((double)5.0, (double)4.025, (double)15.0, (double)7.0, (double)6.025, (double)17.0));
            case Direction.WEST -> Shapes.or((VoxelShape)PigCorpseSkeletonBlock.box((double)5.00518, (double)0.10082, (double)0.0473, (double)12.80518, (double)9.90082, (double)15.8473), (VoxelShape)PigCorpseSkeletonBlock.box((double)9.0, (double)4.025, (double)-1.0, (double)11.0, (double)6.025, (double)1.0));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        ShouldBleedProcedure.execute((Entity)entity);
        return InteractionResult.SUCCESS;
    }
}

