/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PigheadBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public PigheadBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.0f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)PigheadBlock.box((double)4.05399, (double)-0.0152, (double)3.98128, (double)12.05399, (double)7.9848, (double)11.98128), (VoxelShape[])new VoxelShape[]{PigheadBlock.box((double)6.05399, (double)0.9848, (double)11.98128, (double)10.05399, (double)3.9848, (double)12.98128), PigheadBlock.box((double)7.07817, (double)3.96661, (double)5.31979, (double)9.07817, (double)5.96661, (double)7.31979)});
            case Direction.NORTH -> Shapes.or((VoxelShape)PigheadBlock.box((double)3.94601, (double)-0.0152, (double)4.01872, (double)11.94601, (double)7.9848, (double)12.01872), (VoxelShape[])new VoxelShape[]{PigheadBlock.box((double)5.94601, (double)0.9848, (double)3.01872, (double)9.94601, (double)3.9848, (double)4.01872), PigheadBlock.box((double)6.92183, (double)3.96661, (double)8.68021, (double)8.92183, (double)5.96661, (double)10.68021)});
            case Direction.EAST -> Shapes.or((VoxelShape)PigheadBlock.box((double)3.98128, (double)-0.0152, (double)3.94601, (double)11.98128, (double)7.9848, (double)11.94601), (VoxelShape[])new VoxelShape[]{PigheadBlock.box((double)11.98128, (double)0.9848, (double)5.94601, (double)12.98128, (double)3.9848, (double)9.94601), PigheadBlock.box((double)5.31979, (double)3.96661, (double)6.92183, (double)7.31979, (double)5.96661, (double)8.92183)});
            case Direction.WEST -> Shapes.or((VoxelShape)PigheadBlock.box((double)4.01872, (double)-0.0152, (double)4.05399, (double)12.01872, (double)7.9848, (double)12.05399), (VoxelShape[])new VoxelShape[]{PigheadBlock.box((double)3.01872, (double)0.9848, (double)6.05399, (double)4.01872, (double)3.9848, (double)10.05399), PigheadBlock.box((double)8.68021, (double)3.96661, (double)7.07817, (double)10.68021, (double)5.96661, (double)9.07817)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

