/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelapron<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"butcher", (String)"modelapron"), "main");
    public final ModelPart Chestplate;
    public final ModelPart RightPlate;
    public final ModelPart LeftPlate;
    public final ModelPart RightBoot;
    public final ModelPart LeftBoot;

    public Modelapron(ModelPart root) {
        this.Chestplate = root.getChild("Chestplate");
        this.RightPlate = root.getChild("RightPlate");
        this.LeftPlate = root.getChild("LeftPlate");
        this.RightBoot = root.getChild("RightBoot");
        this.LeftBoot = root.getChild("LeftBoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Chestplate2 = partdefinition.addOrReplaceChild("Chestplate", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 21.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightPlate = partdefinition.addOrReplaceChild("RightPlate", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftPlate = partdefinition.addOrReplaceChild("LeftPlate", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.75f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightBoot = partdefinition.addOrReplaceChild("RightBoot", CubeListBuilder.create().texOffs(24, 14).addBox(-2.0f, 2.0f, -1.973f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.75f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition LeftBoot = partdefinition.addOrReplaceChild("LeftBoot", CubeListBuilder.create().texOffs(24, 14).mirror().addBox(-2.0f, 5.0f, -1.973f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.75f)).mirror(false), PartPose.offset((float)1.9f, (float)9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.Chestplate.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightPlate.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftPlate.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.RightBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.LeftBoot.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftPlate.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.LeftBoot.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.RightBoot.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.RightPlate.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
    }
}

