/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butcher.fluid;

import net.mcreator.butcher.init.ButcherModBlocks;
import net.mcreator.butcher.init.ButcherModFluidTypes;
import net.mcreator.butcher.init.ButcherModFluids;
import net.mcreator.butcher.init.ButcherModItems;
import net.mcreator.butcher.init.ButcherModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class BloodLiquidFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)ButcherModFluidTypes.BLOOD_LIQUID_TYPE.get(), () -> (Fluid)ButcherModFluids.BLOOD_LIQUID.get(), () -> (Fluid)ButcherModFluids.FLOWING_BLOOD_LIQUID.get()).explosionResistance(1.0E8f).bucket(() -> (Item)ButcherModItems.BLOOD_LIQUID_BUCKET.get()).block(() -> (LiquidBlock)ButcherModBlocks.BLOOD_LIQUID.get());

    private BloodLiquidFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)ButcherModParticleTypes.BLOOD.get();
    }

    public static class Flowing
    extends BloodLiquidFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends BloodLiquidFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

