/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.model;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.client.model.ModelIdentifiers;
import net.untitledduckmod.client.model.WaterfowlModel;
import net.untitledduckmod.common.entity.DuckEntity;

public class DuckModel
extends WaterfowlModel<DuckEntity> {
    public DuckModel() {
        super(DuckMod.id("duck"));
    }

    public ResourceLocation getModelResource(DuckEntity object) {
        return ModelIdentifiers.DUCK_MODEL_LOCATION;
    }

    public ResourceLocation getTextureResource(DuckEntity animatable) {
        if (animatable.isBaby()) {
            return ModelIdentifiers.DUCKLING_TEXTURE;
        }
        if (animatable.hasCustomName()) {
            String name;
            switch (name = Objects.requireNonNull(animatable.getCustomName()).getString().toLowerCase()) {
                case "pekin": {
                    return ModelIdentifiers.PEKIN_TEXTURE;
                }
            }
        }
        byte variant = animatable.getVariant();
        return switch (variant) {
            case 1 -> ModelIdentifiers.FEMALE_TEXTURE;
            case 2 -> ModelIdentifiers.CAMPBELL_TEXTURE;
            default -> ModelIdentifiers.NORMAL_TEXTURE;
        };
    }

    public ResourceLocation getAnimationResource(DuckEntity animatable) {
        return ModelIdentifiers.DUCK_ANIMATION_FILE_LOCATION;
    }
}

