/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.model;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.untitledduckmod.DuckMod;
import net.untitledduckmod.client.model.ModelIdentifiers;
import net.untitledduckmod.client.model.WaterfowlModel;
import net.untitledduckmod.common.entity.GooseEntity;

public class GooseModel
extends WaterfowlModel<GooseEntity> {
    public GooseModel() {
        super(DuckMod.id("goose"));
    }

    public ResourceLocation getModelResource(GooseEntity object) {
        return ModelIdentifiers.GOOSE_MODEL_LOCATION;
    }

    public ResourceLocation getTextureResource(GooseEntity entity) {
        if (entity.isBaby()) {
            return ModelIdentifiers.GOSLING_TEXTURE;
        }
        if (entity.hasCustomName()) {
            String name;
            switch (name = Objects.requireNonNull(entity.getCustomName()).getString().toLowerCase()) {
                case "ping": {
                    return ModelIdentifiers.PING_GOOSE_TEXTURE;
                }
                case "sus": {
                    return ModelIdentifiers.SUS_GOOSE_TEXTURE;
                }
                case "untitled": {
                    return ModelIdentifiers.UNTITLED_GOOSE_TEXTURE;
                }
            }
        }
        return entity.getVariant() == 0 ? ModelIdentifiers.GOOSE_TEXTURE : ModelIdentifiers.CANADIAN_GOOSE_TEXTURE;
    }

    public ResourceLocation getAnimationResource(GooseEntity animatable) {
        return ModelIdentifiers.GOOSE_ANIMATION_FILE_LOCATION;
    }
}

