/*
 * Decompiled with CFR 0.152.
 */
package net.untitledduckmod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.untitledduckmod.common.entity.DuckEntity;
import net.untitledduckmod.common.entity.GooseEntity;
import net.untitledduckmod.common.entity.WaterfowlEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class WaterfowlRenderer<T extends WaterfowlEntity>
extends GeoEntityRenderer<T> {
    private static final float ADULT_SHADOW_RADIUS = 0.3f;
    private final ItemInHandRenderer heldItemRenderer;

    public WaterfowlRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model) {
        super(renderManager, model);
        this.shadowRadius = 0.3f;
        this.heldItemRenderer = renderManager.getItemInHandRenderer();
    }

    protected float getShadowRadius(T animatable) {
        return super.getShadowRadius(animatable) * animatable.getAgeScale();
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        float modelScale = animatable.getAgeScale();
        this.withScale(modelScale);
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        ItemStack mainHand = animatable.getMainHandItem();
        if (bone.getName().equals("beak") && !mainHand.isEmpty()) {
            poseStack.pushPose();
            if (animatable instanceof DuckEntity) {
                poseStack.translate(0.0, 0.5, -0.4);
            } else if (animatable instanceof GooseEntity) {
                poseStack.translate(0.0, 1.15, -0.45);
            }
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            poseStack.scale(0.7f, 0.7f, 0.7f);
            this.heldItemRenderer.renderItem(animatable, mainHand, ItemDisplayContext.GROUND, false, poseStack, bufferSource, packedLight);
            poseStack.popPose();
            buffer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation((Entity)animatable)));
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }
}

