/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.ponder.scenes;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltPart;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlockEntity;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import java.util.ArrayList;
import java.util.Collections;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotElement;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeltScenes {
    public static void beltConnector(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_connector", "Using Mechanical Belts");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.world().showSection(util.select().position(3, 0, 5), Direction.UP);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(4, 1, 3, 4, 1, 5), Direction.DOWN);
        ElementLink shafts = scene.world().showIndependentSection(util.select().fromTo(0, 1, 3, 4, 1, 3), Direction.DOWN);
        scene.world().moveSection(shafts, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.world().setKineticSpeed(util.select().position(0, 1, 3), 0.0f);
        scene.idle(20);
        BlockPos backEnd = util.grid().at(4, 1, 2);
        BlockPos frontEnd = util.grid().at(0, 1, 2);
        ItemStack beltItem = AllItems.BELT_CONNECTOR.asStack();
        Vec3 backEndCenter = util.vector().centerOf(backEnd);
        AABB connectBB = new AABB(backEndCenter, backEndCenter);
        AABB shaftBB = ((BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z)).getShape(null, null).bounds();
        scene.overlay().showControls(util.vector().topOf(backEnd), Pointing.DOWN, 57).rightClick().withItem(beltItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)backEnd, shaftBB.move(backEnd), 42);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLACK, (Object)backEndCenter, connectBB, 50);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(frontEnd), Pointing.DOWN, 37).rightClick().withItem(beltItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.GREEN, (Object)frontEnd, shaftBB.move(frontEnd), 17);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.BLACK, (Object)backEndCenter, connectBB.expandTowards(-4.0, 0.0, 0.0), 20);
        scene.idle(20);
        scene.world().moveSection(shafts, util.vector().of(0.0, -2.0, 0.0), 0);
        scene.world().showSection(util.select().fromTo(0, 1, 2, 4, 1, 2), Direction.SOUTH);
        scene.idle(20);
        scene.overlay().showText(80).text("Right-Clicking two shafts with a belt item will connect them together").attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(2, 1, 2));
        scene.idle(90);
        Vec3 falseSelection = util.vector().topOf(backEnd.south(1));
        scene.overlay().showControls(falseSelection, Pointing.DOWN, 37).rightClick().withItem(beltItem);
        scene.idle(7);
        scene.overlay().chaseBoundingBoxOutline(PonderPalette.RED, (Object)backEnd, shaftBB.move(backEnd.south(1)), 50);
        scene.overlay().showText(80).colored(PonderPalette.RED).text("Accidental selections can be canceled with Right-Click while Sneaking").attachKeyFrame().placeNearTarget().pointAt(util.vector().centerOf(backEnd.south(1)));
        scene.idle(43);
        scene.overlay().showControls(falseSelection, Pointing.DOWN, 20).rightClick().withItem(beltItem).whileSneaking();
        scene.idle(60);
        BlockPos shaftLocation = frontEnd.east();
        scene.overlay().showControls(util.vector().topOf(shaftLocation), Pointing.DOWN, 50).rightClick().withItem(AllBlocks.SHAFT.asStack());
        scene.idle(7);
        scene.world().modifyBlock(shaftLocation, s -> (BlockState)s.setValue(BeltBlock.PART, (Comparable)((Object)BeltPart.PULLEY)), true);
        scene.idle(10);
        scene.overlay().showText(43).text("Additional Shafts can be added throughout the Belt").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(shaftLocation, Direction.NORTH));
        scene.idle(50);
        Selection attachedShafts = util.select().fromTo(0, 1, 1, 1, 1, 1);
        scene.world().showSection(attachedShafts, Direction.SOUTH);
        scene.world().setKineticSpeed(attachedShafts, 32.0f);
        scene.idle(10);
        scene.effects().rotationDirectionIndicator(util.grid().at(0, 1, 1));
        scene.effects().rotationDirectionIndicator(util.grid().at(1, 1, 1));
        scene.idle(20);
        scene.overlay().showText(50).text("Shafts connected via Belts will rotate with Identical Speed and Direction").placeNearTarget().pointAt(util.vector().blockSurface(util.grid().at(0, 1, 1), Direction.NORTH));
        scene.idle(60);
        scene.world().hideSection(attachedShafts, Direction.NORTH);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(shaftLocation), Pointing.DOWN, 50).rightClick().withItem(AllItems.WRENCH.asStack());
        scene.idle(7);
        scene.world().modifyBlock(shaftLocation, s -> (BlockState)s.setValue(BeltBlock.PART, (Comparable)((Object)BeltPart.MIDDLE)), true);
        scene.idle(10);
        scene.overlay().showText(50).text("Added shafts can be removed using the wrench").attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(shaftLocation, Direction.NORTH));
        scene.idle(70);
        scene.overlay().showControls(util.vector().topOf(shaftLocation.east()), Pointing.DOWN, 50).rightClick().withItem(new ItemStack((ItemLike)Items.BLUE_DYE));
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(util.select().fromTo(0, 1, 2, 4, 1, 2), BeltBlockEntity.class, nbt -> NBTHelper.writeEnum((CompoundTag)nbt, (String)"Dye", (Enum)DyeColor.BLUE));
        scene.idle(20);
        scene.overlay().showText(80).colored(PonderPalette.BLUE).text("Mechanical Belts can be dyed for aesthetic purposes").placeNearTarget().pointAt(util.vector().topOf(shaftLocation.east()));
        scene.idle(50);
    }

    public static void directions(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_directions", "Valid Orientations for Mechanical Belts");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.idle(5);
        ElementLink leftShaft = scene.world().showIndependentSection(util.select().position(4, 1, 0), Direction.DOWN);
        ElementLink rightShaft = scene.world().showIndependentSection(util.select().position(0, 1, 0), Direction.DOWN);
        scene.world().moveSection(leftShaft, util.vector().of(0.0, 0.0, 2.0), 0);
        scene.world().moveSection(rightShaft, util.vector().of(0.0, 0.0, 2.0), 0);
        scene.idle(1);
        scene.world().moveSection(leftShaft, util.vector().of(-1.0, 0.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(1.0, 1.0, 0.0), 10);
        scene.idle(20);
        Vec3 from = util.vector().centerOf(3, 1, 2);
        Vec3 to = util.vector().centerOf(1, 2, 2);
        scene.overlay().showLine(PonderPalette.RED, from, to, 70);
        scene.idle(10);
        scene.overlay().showLine(PonderPalette.GREEN, to.add(-1.0, -1.0, 0.0), from, 60);
        scene.overlay().showLine(PonderPalette.GREEN, from.add(0.0, 3.0, 0.0), from, 60);
        scene.idle(20);
        scene.overlay().showText(60).colored(PonderPalette.RED).placeNearTarget().pointAt(to).text("Belts cannot connect in arbitrary directions");
        scene.idle(70);
        from = util.vector().centerOf(4, 1, 2);
        to = util.vector().centerOf(0, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(-1.0, -1.0, 0.0), 10);
        scene.idle(10);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 40);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("1. They can connect horizontally");
        scene.idle(20);
        Selection firstBelt = util.select().fromTo(4, 1, 1, 0, 1, 1);
        ElementLink belt = scene.world().showIndependentSection(firstBelt, Direction.SOUTH);
        scene.world().moveSection(belt, util.vector().of(0.0, 0.0, 1.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(belt, Direction.SOUTH);
        scene.idle(15);
        from = util.vector().centerOf(3, 3, 2);
        to = util.vector().centerOf(1, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(-1.0, 2.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().rotateSection(leftShaft, 0.0, 0.0, 25.0, 5);
        scene.world().rotateSection(rightShaft, 0.0, 0.0, 25.0, 5);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 40);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("2. They can connect diagonally");
        scene.idle(20);
        Selection secondBelt = util.select().fromTo(3, 3, 2, 1, 1, 2);
        belt = scene.world().showIndependentSection(secondBelt, Direction.SOUTH);
        scene.idle(20);
        scene.world().hideIndependentSection(belt, Direction.SOUTH);
        scene.idle(15);
        from = util.vector().centerOf(2, 4, 2);
        to = util.vector().centerOf(2, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(-1.0, 1.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(1.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().rotateSection(rightShaft, 0.0, 0.0, -25.0, 5);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 40);
        scene.idle(10);
        scene.overlay().showText(40).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("3. They can connect vertically");
        scene.idle(20);
        Selection thirdBelt = util.select().fromTo(2, 1, 3, 2, 4, 3);
        belt = scene.world().showIndependentSection(thirdBelt, Direction.SOUTH);
        scene.world().moveSection(belt, util.vector().of(0.0, 0.0, -1.0), 0);
        scene.idle(20);
        scene.world().hideIndependentSection(belt, Direction.SOUTH);
        scene.idle(15);
        from = util.vector().centerOf(4, 1, 2);
        to = util.vector().centerOf(0, 1, 2);
        scene.world().moveSection(leftShaft, util.vector().of(2.0, -3.0, 0.0), 10);
        scene.world().moveSection(rightShaft, util.vector().of(-2.0, 0.0, 0.0), 10);
        scene.idle(10);
        scene.world().rotateSection(rightShaft, 90.0, 0.0, -25.0, 5);
        scene.world().rotateSection(leftShaft, 90.0, 0.0, -50.0, 5);
        scene.overlay().showLine(PonderPalette.GREEN, from, to, 60);
        scene.idle(10);
        scene.overlay().showText(60).colored(PonderPalette.GREEN).placeNearTarget().pointAt(to).attachKeyFrame().text("4. And they can connect vertical shafts horizontally");
        scene.idle(20);
        Selection fourthBelt = util.select().fromTo(4, 1, 4, 0, 1, 4);
        belt = scene.world().showIndependentSection(fourthBelt, Direction.DOWN);
        scene.world().moveSection(belt, util.vector().of(0.0, 0.001953125, -2.0), 0);
        scene.idle(40);
        scene.world().hideIndependentSection(belt, Direction.UP);
        scene.idle(15);
        scene.world().hideIndependentSection(leftShaft, Direction.UP);
        scene.world().hideIndependentSection(rightShaft, Direction.UP);
        scene.idle(15);
        scene.world().showSection(firstBelt, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(secondBelt, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(thirdBelt, Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(fourthBelt, Direction.DOWN);
        scene.idle(10);
        scene.overlay().showText(160).text("These are all possible directions. Belts can span any Length between 2 and 20 blocks");
        scene.markAsFinished();
    }

    public static void transport(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_transport", "Using Mechanical Belts for Logistics");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.world().modifyKineticSpeed(util.select().everywhere(), f -> Float.valueOf(-0.6f * f.floatValue()));
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 3, 2, 1, 5), Direction.DOWN);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(2, 1, 2, 4, 3, 2), Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 1, 2, 0, 1, 2), Direction.SOUTH);
        scene.idle(10);
        scene.special().movePointOfInterest(util.grid().at(2, 2, 0));
        ItemStack stack = new ItemStack((ItemLike)Items.COPPER_BLOCK);
        ElementLink item = scene.world().createItemEntity(util.vector().centerOf(0, 4, 2), util.vector().of(0.0, 0.0, 0.0), stack);
        scene.idle(13);
        scene.world().modifyEntity(item, Entity::discard);
        BlockPos beltEnd = util.grid().at(0, 1, 2);
        scene.world().createItemOnBelt(beltEnd, Direction.DOWN, stack);
        scene.idle(20);
        ElementLink<ParrotElement> parrot = scene.special().createBirb(util.vector().topOf(0, 1, 2).add(0.0, -0.1875, 0.0), ParrotPose.FacePointOfInterestPose::new);
        scene.special().moveParrot(parrot, util.vector().of(1.78, 0.0, 0.0), 40);
        scene.special().movePointOfInterest(util.grid().at(1, 1, 3));
        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().topOf(beltEnd)).text("Moving belts will transport Items and other Entities");
        scene.idle(20);
        item = scene.world().createItemEntity(util.vector().centerOf(0, 4, 2), util.vector().of(0.0, 0.0, 0.0), stack);
        scene.special().movePointOfInterest(util.grid().at(0, 3, 2));
        scene.idle(10);
        scene.special().movePointOfInterest(beltEnd);
        scene.idle(3);
        scene.world().modifyEntity(item, Entity::discard);
        scene.world().createItemOnBelt(beltEnd, Direction.DOWN, stack);
        scene.idle(8);
        scene.special().movePointOfInterest(util.grid().at(3, 2, 1));
        scene.special().moveParrot(parrot, util.vector().of(2.1, 2.1, 0.0), 60);
        scene.idle(20);
        scene.special().movePointOfInterest(util.grid().at(5, 5, 2));
        scene.idle(30);
        scene.special().movePointOfInterest(util.grid().at(2, 1, 5));
        scene.idle(10);
        scene.special().moveParrot(parrot, util.vector().of(0.23, 0.0, 0.0), 5);
        scene.idle(5);
        scene.world().setKineticSpeed(util.select().everywhere(), 0.0f);
        scene.idle(10);
        scene.world().modifyEntities(ItemEntity.class, Entity::discard);
        scene.special().movePointOfInterest(util.grid().at(2, 5, 4));
        Vec3 topOf = util.vector().topOf(util.grid().at(3, 2, 2)).add(-0.1, 0.3, 0.0);
        scene.overlay().showControls(topOf, Pointing.DOWN, 60).rightClick();
        scene.idle(10);
        scene.overlay().showText(60).placeNearTarget().pointAt(topOf.subtract(0.0, 0.1, 0.0)).attachKeyFrame().text("Right-Click with an empty hand to take items off a belt");
        scene.idle(20);
        scene.world().removeItemsFromBelt(util.grid().at(3, 2, 2));
        scene.effects().indicateSuccess(util.grid().at(3, 2, 2));
        scene.idle(20);
        scene.special().changeBirbPose(parrot, ParrotPose.FaceCursorPose::new);
    }

    public static void beltsCanBeEncased(SceneBuilder builder, SceneBuildingUtil util) {
        int x;
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("belt_casing", "Encasing Belts");
        scene.configureBasePlate(0, 0, 5);
        scene.setSceneOffsetY(-1.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().showSection(util.select().layersFrom(1), Direction.DOWN);
        scene.idle(20);
        ItemStack brassCasingItem = AllBlocks.BRASS_CASING.asStack();
        ItemStack andesiteCasingItem = AllBlocks.ANDESITE_CASING.asStack();
        BlockPos beltPos = util.grid().at(3, 1, 0);
        BlockPos beltPos2 = util.grid().at(0, 2, 3);
        BlockPos beltPos3 = util.grid().at(1, 4, 4);
        scene.overlay().showControls(util.vector().topOf(beltPos), Pointing.DOWN, 20).rightClick().withItem(brassCasingItem);
        scene.idle(7);
        scene.world().modifyBlock(beltPos, s -> (BlockState)s.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        scene.idle(20);
        scene.overlay().showControls(util.vector().topOf(beltPos2), Pointing.DOWN, 20).rightClick().withItem(andesiteCasingItem);
        scene.idle(7);
        scene.world().modifyBlock(beltPos2, s -> (BlockState)s.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        scene.world().modifyBlockEntityNBT(util.select().position(beltPos2), BeltBlockEntity.class, nbt -> NBTHelper.writeEnum((CompoundTag)nbt, (String)"Casing", (Enum)BeltBlockEntity.CasingType.ANDESITE));
        scene.idle(20);
        scene.overlay().showControls(util.vector().blockSurface(beltPos3, Direction.EAST), Pointing.RIGHT, 20).rightClick().withItem(brassCasingItem);
        scene.idle(7);
        scene.world().modifyBlock(beltPos3, s -> (BlockState)s.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        scene.idle(20);
        scene.overlay().showText(80).text("Brass or Andesite Casing can be used to decorate Mechanical Belts").attachKeyFrame().pointAt(util.vector().centerOf(beltPos2));
        scene.idle(40);
        ArrayList<BlockPos> brassBelts = new ArrayList<BlockPos>();
        ArrayList<BlockPos> andesiteBelts = new ArrayList<BlockPos>();
        for (int z = 1; z <= 3; ++z) {
            brassBelts.add(beltPos.south(z));
        }
        for (x = 1; x <= 3; ++x) {
            brassBelts.add(beltPos3.east(x).below(x));
        }
        for (x = 1; x <= 3; ++x) {
            andesiteBelts.add(beltPos2.east(x));
        }
        Collections.shuffle(andesiteBelts);
        Collections.shuffle(brassBelts);
        for (BlockPos pos : andesiteBelts) {
            scene.idle(4);
            scene.world().modifyBlock(pos, s -> (BlockState)s.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
            scene.world().modifyBlockEntityNBT(util.select().position(pos), BeltBlockEntity.class, nbt -> NBTHelper.writeEnum((CompoundTag)nbt, (String)"Casing", (Enum)BeltBlockEntity.CasingType.ANDESITE));
        }
        for (BlockPos pos : brassBelts) {
            scene.idle(4);
            scene.world().modifyBlock(pos, s -> (BlockState)s.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(true)), true);
        }
        scene.idle(30);
        scene.addKeyframe();
        scene.overlay().showControls(util.vector().topOf(beltPos.south()), Pointing.DOWN, 40).rightClick().withItem(AllItems.WRENCH.asStack());
        scene.idle(7);
        scene.world().modifyBlock(beltPos.south(), s -> (BlockState)s.setValue((Property)BeltBlock.CASING, (Comparable)Boolean.valueOf(false)), true);
        scene.overlay().showText(80).text("A wrench can be used to remove the casing").placeNearTarget().pointAt(util.vector().blockSurface(beltPos.south(), Direction.WEST));
    }

    public static void depot(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("depot", "Using Depots");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world().setBlock(util.grid().at(3, 2, 2), Blocks.WATER.defaultBlockState(), false);
        BlockPos depotPos = util.grid().at(2, 1, 2);
        scene.world().showSection(util.select().position(2, 1, 2), Direction.DOWN);
        Vec3 topOf = util.vector().topOf(depotPos);
        scene.overlay().showText(60).attachKeyFrame().text("Depots can serve as 'stationary' belt elements").placeNearTarget().pointAt(topOf);
        scene.idle(70);
        scene.overlay().showControls(topOf, Pointing.DOWN, 20).rightClick().withItem(new ItemStack((ItemLike)Items.COPPER_BLOCK));
        scene.idle(7);
        scene.world().createItemOnBeltLike(depotPos, Direction.NORTH, new ItemStack((ItemLike)Items.COPPER_BLOCK));
        scene.idle(10);
        scene.overlay().showText(70).attachKeyFrame().text("Right-Click to manually place or remove Items from it").placeNearTarget().pointAt(topOf);
        scene.idle(80);
        scene.overlay().showControls(topOf, Pointing.DOWN, 20).rightClick();
        scene.idle(7);
        scene.world().removeItemsFromBelt(depotPos);
        scene.effects().indicateSuccess(depotPos);
        scene.idle(20);
        scene.world().showSection(util.select().position(depotPos.above(2)), Direction.SOUTH);
        scene.overlay().showText(70).attachKeyFrame().text("Just like Mechanical Belts, it can provide items to processing").placeNearTarget().pointAt(util.vector().blockSurface(depotPos.above(2), Direction.WEST));
        ItemStack bottle = new ItemStack((ItemLike)Items.BUCKET);
        scene.world().createItemOnBeltLike(depotPos, Direction.NORTH, bottle);
        scene.idle(20);
        scene.world().modifyBlockEntityNBT(util.select().position(depotPos.above(2)), SpoutBlockEntity.class, nbt -> nbt.putInt("ProcessingTicks", 20));
        scene.idle(20);
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().createItemOnBeltLike(depotPos, Direction.UP, new ItemStack((ItemLike)Items.WATER_BUCKET));
        scene.world().modifyBlockEntityNBT(util.select().position(depotPos.above(2)), SpoutBlockEntity.class, nbt -> nbt.putBoolean("Splash", true));
        scene.idle(30);
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().hideSection(util.select().position(depotPos.above(2)), Direction.SOUTH);
        scene.idle(20);
        ElementLink spout = scene.world().showIndependentSection(util.select().position(depotPos.above(2).west()), Direction.SOUTH);
        scene.world().moveSection(spout, util.vector().of(1.0, 0.0, 0.0), 0);
        BlockPos pressPos = depotPos.above(2).west();
        ItemStack copper = new ItemStack((ItemLike)Items.COPPER_INGOT);
        scene.world().createItemOnBeltLike(depotPos, Direction.NORTH, copper);
        Vec3 depotCenter = util.vector().centerOf(depotPos);
        scene.idle(10);
        Class<MechanicalPressBlockEntity> type = MechanicalPressBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.idle(15);
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.add(0.0, 0.5, 0.0), copper));
        scene.world().removeItemsFromBelt(depotPos);
        ItemStack sheet = AllItems.COPPER_SHEET.asStack();
        scene.world().createItemOnBeltLike(depotPos, Direction.UP, sheet);
        scene.idle(20);
        scene.world().hideIndependentSection(spout, Direction.SOUTH);
        scene.idle(10);
        Selection fanSelect = util.select().fromTo(4, 1, 3, 5, 2, 2).add(util.select().position(3, 1, 2)).add(util.select().position(5, 0, 2));
        scene.world().showSection(fanSelect, Direction.SOUTH);
        ElementLink water = scene.world().showIndependentSection(util.select().position(3, 1, 0), Direction.SOUTH);
        scene.world().moveSection(water, util.vector().of(0.0, 1.0, 2.0), 0);
        scene.idle(30);
        scene.world().hideSection(fanSelect, Direction.SOUTH);
        scene.world().hideIndependentSection(water, Direction.SOUTH);
        scene.idle(30);
        scene.world().showSection(util.select().fromTo(2, 1, 4, 2, 1, 5).add(util.select().position(2, 0, 5)), Direction.DOWN);
        BlockPos armPos = util.grid().at(2, 1, 4);
        scene.overlay().showText(70).attachKeyFrame().text("...as well as provide Items to Mechanical Arms").placeNearTarget().pointAt(util.vector().blockSurface(armPos, Direction.WEST));
        scene.idle(20);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.MOVE_TO_INPUT, ItemStack.EMPTY, 0);
        scene.idle(37);
        scene.world().removeItemsFromBelt(depotPos);
        scene.world().instructArm(armPos, ArmBlockEntity.Phase.SEARCH_OUTPUTS, sheet, -1);
    }
}

